﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FUPCE : Form
    {
        private Imager m_Imager;
        private UPCE_PARAMS m_Upce;

        public FUPCE()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Upce = new UPCE_PARAMS();
        }

        private void FUPCE_Load(object sender, EventArgs e)
        {
            m_Imager.GetUPCE(out m_Upce);

            CB_ENABLE.Checked = m_Upce.bEnable;
            CB_XCD.Checked = m_Upce.bXCD;
            CB_XNUM.Checked = m_Upce.bXNum;
            CB_ADDON.Checked = m_Upce.bAddOn;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Upce.bEnable = CB_ENABLE.Checked;
            m_Upce.bXCD = CB_XCD.Checked;
            m_Upce.bXNum = CB_XNUM.Checked;
            m_Upce.bAddOn = CB_ADDON.Checked;

            m_Imager.SetUPCE(ref m_Upce);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}