﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FUPCA : Form
    {
        private Imager m_Imager;
        private UPCA_PARAMS m_Upca;

        public FUPCA()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Upca = new UPCA_PARAMS();
        }

        private void FUPCA_Load(object sender, EventArgs e)
        {
            m_Imager.GetUPCA(out m_Upca);

            CB_ENABLE.Checked = m_Upca.bEnable;
            CB_XCD.Checked = m_Upca.bXCD;
            CB_XNUM.Checked = m_Upca.bXNum;
            CB_ADDON.Checked = m_Upca.bAddOn;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Upca.bEnable = CB_ENABLE.Checked;
            m_Upca.bXCD = CB_XCD.Checked;
            m_Upca.bXNum = CB_XNUM.Checked;
            m_Upca.bAddOn = CB_ADDON.Checked;

            m_Imager.SetUPCA(ref m_Upca);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}