﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;
using System.Runtime.InteropServices;
using Microsoft.Win32;
using System.Reflection;
using System.IO;

namespace ImagerTestNet
{
    public partial class FTEST : Form
    {
        private Imager m_Imager;
        public DECODER_PARAMS m_DecoderParams;

        public FTEST()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Imager.ImagerDataEvent += new ImagerNet.ImagerDataDelegate(OnScanRead);
        }

        private void BTN_SCAN_Click(object sender, EventArgs e)
        {
            m_Imager.Read();
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            m_Imager.ReadCancel();
        }

        private void BTN_CLOSE_Click(object sender, EventArgs e)
        {
            Close();
        }

        public void OnScanRead(object sender, ImagerDataArgs e)
        {
            if (e.ScanData != "")
            {
                LB_TYPE.Text = e.ScanType;
                TB_DATA.Text = e.ScanData;
            }
        }

        private void FTEST_Closing(object sender, CancelEventArgs e)
        {
            m_Imager.ImagerDataEvent -= new ImagerNet.ImagerDataDelegate(OnScanRead);
            this.DialogResult = DialogResult.OK;
        }
        
    }
}