﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FTELEPEN : Form
    {
        private Imager m_Imager;
        private TELEPEN_PARAMS m_Telepen;

        public FTELEPEN()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Telepen = new TELEPEN_PARAMS();
        }

        private void FTELEPEN_Load(object sender, EventArgs e)
        {
            m_Imager.GetTELEPEN(out m_Telepen);

            CB_ENABLE.Checked = m_Telepen.bEnable;
            CB_NUMERIC.Checked = m_Telepen.bNumeric;

            TB_MINLEN.Text = m_Telepen.nMinLen.ToString();
            TB_MAXLEN.Text = m_Telepen.nMaxLen.ToString();

        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Telepen.bEnable = CB_ENABLE.Checked;
            m_Telepen.bNumeric = CB_NUMERIC.Checked;

            m_Telepen.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
            m_Telepen.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

            m_Imager.SetTELEPEN(ref m_Telepen);

            this.DialogResult = DialogResult.OK;

        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}