﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;


namespace ImagerTestNet
{      
    public partial class FSYMBOLOGY : Form
    {

        private Imager m_Imager;
        public DECODER m_Decoder;

        public AZTEC_PARAMS         m_Aztec;
        public CODABAR_PARAMS       m_Codabar;
        public CODE11_PARAMS        m_Code11;
        public CODE128_PARAMS       m_Code128;
        public CODE39_PARAMS        m_Code39;
        public CODE49_PARAMS        m_Code49;
        public CODE93_PARAMS        m_Code93;
        public COMPOSITE_PARAMS     m_Composite;
        public DATAMATRIX_PARAMS    m_Datamatrix;
        public EAN8_PARAMS          m_Ean8;
        public EAN13_PARAMS         m_Ean13;
        public INT25_PARAMS         m_Int25;
        public MAXICODE_PARAMS      m_Maxicode;
        public MICROPDF_PARAMS      m_Micropdf;
        public OCR_PARAMS           m_Ocr;
        public PDF417_PARAMS        m_Pdf417;
        public POSTNET_PARAMS       m_Postnet;
        public QR_PARAMS            m_Qr;
        public RSS_PARAMS           m_Rss;
        public UPCA_PARAMS          m_Upca;
        public UPCE_PARAMS          m_Upce;
        public IATA25_PARAMS        m_Iata25;
        public CODABLOCK_PARAMS     m_Codablock;
        public PLANET_PARAMS        m_Planet;
        public MSI_PARAMS           m_Msi;
        public STRT25_PARAMS        m_Strt25;
        public MATRIX25_PARAMS      m_Matrix25;
        public PLESSEY_PARAMS       m_Plessey;
        public CHINAPOST_PARAMS     m_Chinapost;
        public KOREAPOST_PARAMS     m_Koreapost;
        public TELEPEN_PARAMS       m_Telepen;
        public CODE16K_PARAMS       m_Code16k;
        public POSICODE_PARAMS      m_Posicode;


        private const int AZTEC         = 0;
        private const int CODABAR       = 1;
        private const int CODE11        = 2;
        private const int CODE128       = 3;
        private const int CODE39        = 4;
        private const int CODE49        = 5;
        private const int CODE93        = 6;
        private const int COMPOSITE     = 7;
        private const int DATAMATRIX    = 8;
        private const int EAN8          = 9;
        private const int EAN13         = 10;
        private const int INT25         = 11;
        private const int MAXICODE      = 12;
        private const int MICROPDF      = 13;
        private const int OCR           = 14;
        private const int PDF417        = 15;
        private const int POSTNET       = 16;
        private const int QR            = 17;
        private const int RSS           = 18;
        private const int UPCA          = 19;
        private const int UPCE          = 20;
        private const int ISBT          = 21;
        private const int BPO           = 22;
        private const int CANPOST       = 23;
        private const int AUSPOST       = 24;
        private const int IATA25        = 25;
        private const int CODABLOCK     = 26;
        private const int JAPOST        = 27;
        private const int PLANET        = 28;
        private const int DUTCHPOST     = 29;
        private const int MSI           = 30;
        private const int TLCODE39      = 31;        
        private const int STRT25        = 32;
        private const int MATRIX25      = 33;
        private const int PLESSEY       = 34;
        private const int CHINAPOST     = 35;
        private const int KOREAPOST     = 36;
        private const int TELEPEN       = 37;
        private const int CODE16K       = 38;
        private const int POSICODE      = 39;
        private const int COUPONCODE    = 40;
        private const int USBS4CB       = 41;
        private const int IDTAG         = 42;    
        private const int LABEL         = 43;
        private const int GS1_128       = 44;
        private const int HANXIN        = 45;
        private const int GRIDMATRIX    = 46;

        string[] BARCODE_TYPE = new string[] { "AZTEC", "CODABAR", "CODE11", "CODE128", "CODE39", "CODE49",
        "CODE93", "COMPOSITE", "DATAMATRIX", "EAN-8", "EAN-13", "INT25", "MAXICODE", "MICROPDF",
        "OCR", "PDF417", "POSTNET", "QR", "RSS", "UPC-A", "UPC-E", "ISBT", "BPO", "CANAPOST",
        "AUSPOST", "IATA25", "CODABLOCK", "JAPOST", "PLANET", "DUTCHPOST", "MSI", "TLCODE39",
        "STRT25", "MATRIX25", "PLESSEY", "CHINAPOST", "KOREAPOST", "TELEPEN",
        "CODE16K", "POSICODE", "COUPONCODE", "USPS4CB", "IDTAG", "LABEL", "GS1-128",
        "HANXIN", "GRIDMATRIX"};

        bool[] BARCODE_ENABLED = new bool[] {
	true, true, true, true, true, false, true,
	true, true, true, true, true, true, true,	
	false, true, true, true, true, true, true,
	true, true, false, true, true, false, false,	
	true, true, true, true, false,
	true, false, true, true, false, false, true,
	true, true, true, false, true, false, false};

        bool[] BARCODE_ENABLE = new bool[47];

        int Temp = -1;
        int Temp_0 = 0;
     
        public FSYMBOLOGY()
        {
            InitializeComponent();

            m_Imager = new Imager();
        }

        private void FSYMBOLOGY_Load(object sender, EventArgs e)
        {
            ListViewItem BarcodeItem = new ListViewItem();
            
            m_Imager.GetSymbology(out m_Decoder);

            SetCheckBox();
            
            for (int a = 0; a < 47; a++)
            {
                BarcodeItem = new ListViewItem();
                BarcodeItem.Checked = BARCODE_ENABLE[a];
                BarcodeItem.SubItems.Add(BARCODE_TYPE[a]);
                
                if ( !BARCODE_ENABLED[a] )
                    BarcodeItem.ForeColor = Color.LightGray;

                this.LV_SYMLIST.Items.Add(BarcodeItem);
            }

            TB_MINLEN.Text = Temp_0.ToString();
            TB_MAXLEN.Text = Temp_0.ToString();

            LB_MIN.Enabled = false;
            LB_MAX.Enabled = false;
            TB_MINLEN.Enabled = false;
            TB_MAXLEN.Enabled = false;
            BTN_APPLY.Enabled = false;
            BTN_PARAM.Enabled = false;
        }

        

        private void BTN_APPLY_Click(object sender, EventArgs e)
        {
            switch (LV_SYMLIST.FocusedItem.Index)
            {
                case AZTEC:
                    m_Aztec.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Aztec.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetAZTEC(ref m_Aztec) == false)
                        MessageBox.Show("SetAZTEC()");
                    break;

                case CODABAR:
                    m_Codabar.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Codabar.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetCODABAR(ref m_Codabar) == false)
                        MessageBox.Show("SetCODABAR()");
                    break;

                case CODE11:
                    m_Code11.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Code11.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetCODE11(ref m_Code11) == false)
                        MessageBox.Show("SetCODE11()");
                    break;

                case CODE128:
                    m_Code128.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Code128.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetCODE128(ref m_Code128) == false)
                        MessageBox.Show("SetCODE128()");
                    break;

                case CODE39:
                    m_Code39.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Code39.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetCODE39(ref m_Code39) == false)
                        MessageBox.Show("SetCODE39()");
                    break;

                case CODE49:
                    m_Code49.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Code49.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetCODE49(ref m_Code49) == false)
                        MessageBox.Show("SetCODE49()");
                    break;

                case CODE93:
                    m_Code93.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Code93.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetCODE93(ref m_Code93) == false)
                        MessageBox.Show("SetCODE93()");
                    break;

                case COMPOSITE:
                    m_Composite.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Composite.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetCOMPOSITE(ref m_Composite) == false)
                        MessageBox.Show("SetCOMPOSITE()");
                    break;

                case DATAMATRIX:
                    m_Datamatrix.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Datamatrix.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetDATAMATRIX(ref m_Datamatrix) == false)
                        MessageBox.Show("SetDATAMATRIX()");
                    break;


                case INT25:
                    m_Int25.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Int25.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetINT25(ref m_Int25) == false)
                        MessageBox.Show("SetINT25()");
                    break;

                case MAXICODE:
                    m_Maxicode.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Maxicode.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetMAXICODE(ref m_Maxicode) == false)
                        MessageBox.Show("SetMAXICODE()");
                    break;

                case MICROPDF:
                    m_Micropdf.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Micropdf.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetMICROPDF(ref m_Micropdf) == false)
                        MessageBox.Show("SetMICROPDF()");
                    break;

                case PDF417:
                    m_Pdf417.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Pdf417.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetPDF417(ref m_Pdf417) == false)
                        MessageBox.Show("SetPDF417()");
                    break;


                case QR:
                    m_Qr.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Qr.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetQR(ref m_Qr) == false)
                        MessageBox.Show("SetQR()");
                    break;

                case RSS:
                    m_Rss.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Rss.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetRSS(ref m_Rss) == false)
                        MessageBox.Show("SetRSS()");
                    break;


                case IATA25:
                    m_Iata25.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Iata25.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetIATA25(ref m_Iata25) == false)
                        MessageBox.Show("SetIATA25()");
                    break;

                case CODABLOCK:
                    m_Codablock.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Codablock.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetCODABLOCK(ref m_Codablock) == false)
                        MessageBox.Show("SetCODABLOCK()");
                    break;


                case MSI:
                    m_Msi.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Msi.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetMSI(ref m_Msi) == false)
                        MessageBox.Show("SetMSI()");
                    break;

                case STRT25:
                    m_Strt25.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Strt25.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetSTRT25(ref m_Strt25) == false)
                        MessageBox.Show("SetSTRT25()");
                    break;

                case MATRIX25:
                    m_Matrix25.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Matrix25.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetMATRIX25(ref m_Matrix25) == false)
                        MessageBox.Show("SetMATRIX25()");
                    break;

                case PLESSEY:
                    m_Plessey.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Plessey.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetPLESSEY(ref m_Plessey) == false)
                        MessageBox.Show("SetPLESSEY()");
                    break;

                case CHINAPOST:
                    m_Chinapost.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Chinapost.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetCHINAPOST(ref m_Chinapost) == false)
                        MessageBox.Show("SetCHINAPOST()");
                    break;

                case KOREAPOST:
                    m_Koreapost.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Koreapost.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetKOREAPOST(ref m_Koreapost) == false)
                        MessageBox.Show("SetKOREAPOST()");
                    break;

                case TELEPEN:
                    m_Telepen.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Telepen.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetTELEPEN(ref m_Telepen) == false)
                        MessageBox.Show("SetTELEPEN()");
                    break;

                case CODE16K:
                    m_Code16k.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Code16k.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetCODE16K(ref m_Code16k) == false)
                        MessageBox.Show("SetCODE16K()");
                    break;

                case POSICODE:
                    m_Posicode.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
                    m_Posicode.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

                    if (m_Imager.SetPOSICODE(ref m_Posicode) == false)
                        MessageBox.Show("SetPOSICODE()");
                    break;

            }

        }

        private void BTN_ALL_Click(object sender, EventArgs e)
        {
            m_Imager.SetSymbologyAll();

            SetCheckBox();

            for (int i = 0; i < 47; i++)
            {
                if (BARCODE_ENABLE[i] == true)
                    LV_SYMLIST.Items[i].Checked = true;
                else
                    LV_SYMLIST.Items[i].Checked = false;
            }

        }

        private void BTN_PARAM_Click(object sender, EventArgs e)
        {
            switch(LV_SYMLIST.FocusedItem.Index)
            {
                case CODABAR:
                    FCODABAR CodabarDlg = new FCODABAR();
                    if (CodabarDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[CODABAR].Checked = m_Decoder.bCODABAR;
                    break;

                case CODE11:
                    FCODE11 Code11Dlg = new FCODE11();
                    if(Code11Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[CODE11].Checked = m_Code11.bEnable;
                    break;

                case CODE39:
                    FCODE39 Code39Dlg = new FCODE39();
                    if(Code39Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[CODE39].Checked = m_Code39.bEnable;
                    break;

                case COMPOSITE:
                    FCOMPOSITE CompositeDlg = new FCOMPOSITE();
                    if(CompositeDlg.ShowDialog() ==DialogResult.OK)
                        LV_SYMLIST.Items[COMPOSITE].Checked = m_Composite.bEnable;
                    break;

                case EAN13:
                    FEAN13 Ean13Dlg = new FEAN13();
                    if(Ean13Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[EAN13].Checked = m_Ean13.bEnable;
                    break;

                case EAN8:
                    FEAN8 Ean8Dlg = new FEAN8();
                    if(Ean8Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[EAN8].Checked = m_Ean8.bEnable;
                    break;

                case INT25:
                    FINT25 Int25Dlg = new FINT25();
                    if(Int25Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[INT25].Checked = m_Int25.bEnable;
                    break;

                case MSI:
                    FMSI MsiDlg = new FMSI();
                    if(MsiDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[MSI].Checked = m_Msi.bEnable;
                    break;

                case OCR:
                    FOCR OcrDlg = new FOCR();
                    if(OcrDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[OCR].Checked = m_Ocr.bEnable;
                    break;

                case POSTNET:
                    FPOSTNET PostnetDlg = new FPOSTNET();
                    if (PostnetDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[POSTNET].Checked = m_Postnet.bEnable;
                    break;

                case PLANET:
                    FPLANET PlanetDlg = new FPLANET();
                    if(PlanetDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[PLANET].Checked = m_Planet.bEnable;
                    break;

                case POSICODE:
                    FPOSICODE PosicodeDlg = new FPOSICODE();
                    if(PosicodeDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[POSICODE].Checked = m_Posicode.bEnable;
                    break;

                case RSS:
                    FRSS RssDlg = new FRSS();
                    if(RssDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[RSS].Checked = m_Rss.bEnable;
                    break;

                case TELEPEN:
                    FTELEPEN TelepenDlg = new FTELEPEN();
                    if(TelepenDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[TELEPEN].Checked = m_Telepen.bEnable;
                    break;

                case UPCA:
                    FUPCA UpcaDlg = new FUPCA();
                    if(UpcaDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[UPCA].Checked = m_Upca.bEnable;
                    break;

                case UPCE:
                    FUPCE UpceDlg = new FUPCE();
                    if(UpceDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[UPCE].Checked = m_Upce.bEnable;
                    break;
            }

            
            
        }

        private void BTN_DAFAULT_Click(object sender, EventArgs e)
        {
            m_Imager.SetSymbologyDefault();

            SetCheckBox();

            for (int i = 0; i < 47; i++)
            {
                if (BARCODE_ENABLE[i] == true)
                    LV_SYMLIST.Items[i].Checked = true;
                else
                    LV_SYMLIST.Items[i].Checked = false;
            }
        }

        private void OK_Click(object sender, EventArgs e)
        {
            m_Decoder.bAZTEC = LV_SYMLIST.Items[0].Checked;
            m_Decoder.bCODABAR = LV_SYMLIST.Items[1].Checked;
            m_Decoder.bCODE11 = LV_SYMLIST.Items[2].Checked;
            m_Decoder.bCODE128 = LV_SYMLIST.Items[3].Checked;
            m_Decoder.bCODE39 = LV_SYMLIST.Items[4].Checked;
            m_Decoder.bCODE49 = LV_SYMLIST.Items[5].Checked;
            m_Decoder.bCODE93 = LV_SYMLIST.Items[6].Checked;
            m_Decoder.bCOMPOSITE = LV_SYMLIST.Items[7].Checked;
            m_Decoder.bDATAMATRIX = LV_SYMLIST.Items[8].Checked;
            m_Decoder.bEAN8 = LV_SYMLIST.Items[9].Checked;
            m_Decoder.bEAN13 = LV_SYMLIST.Items[10].Checked;
            m_Decoder.bINT25 = LV_SYMLIST.Items[11].Checked;
            m_Decoder.bMAXICODE = LV_SYMLIST.Items[12].Checked;
            m_Decoder.bMICROPDF = LV_SYMLIST.Items[13].Checked;
            m_Decoder.bOCR = LV_SYMLIST.Items[14].Checked;
            m_Decoder.bPDF417 = LV_SYMLIST.Items[15].Checked;
            m_Decoder.bPOSTNET = LV_SYMLIST.Items[16].Checked;
            m_Decoder.bQR = LV_SYMLIST.Items[17].Checked;
            m_Decoder.bRSS = LV_SYMLIST.Items[18].Checked;
            m_Decoder.bUPCA = LV_SYMLIST.Items[19].Checked;
            m_Decoder.bUPCE = LV_SYMLIST.Items[20].Checked;
            m_Decoder.bISBT = LV_SYMLIST.Items[21].Checked;
            m_Decoder.bBPO = LV_SYMLIST.Items[22].Checked;
            m_Decoder.bCANPOST = LV_SYMLIST.Items[23].Checked;
            m_Decoder.bAUSPOST = LV_SYMLIST.Items[24].Checked;
            m_Decoder.bIATA25 = LV_SYMLIST.Items[25].Checked;
            m_Decoder.bCODABLOCK = LV_SYMLIST.Items[26].Checked;
            m_Decoder.bJAPOST = LV_SYMLIST.Items[27].Checked;
            m_Decoder.bPLANET = LV_SYMLIST.Items[28].Checked;
            m_Decoder.bDUTCHPOST = LV_SYMLIST.Items[29].Checked;
            m_Decoder.bMSI = LV_SYMLIST.Items[30].Checked;
            m_Decoder.bTLCODE39 = LV_SYMLIST.Items[31].Checked;            
            m_Decoder.bSTRT25 = LV_SYMLIST.Items[32].Checked;
            m_Decoder.bMATRIX25 = LV_SYMLIST.Items[33].Checked;
            m_Decoder.bPLESSEY = LV_SYMLIST.Items[34].Checked;
            m_Decoder.bCHINAPOST = LV_SYMLIST.Items[35].Checked;
            m_Decoder.bKOREAPOST = LV_SYMLIST.Items[36].Checked;
            m_Decoder.bTELEPEN = LV_SYMLIST.Items[37].Checked;
            m_Decoder.bCODE16K = LV_SYMLIST.Items[38].Checked;
            m_Decoder.bPOSICODE = LV_SYMLIST.Items[39].Checked;
            m_Decoder.bCOUPONCODE = LV_SYMLIST.Items[40].Checked;
            m_Decoder.bUSPS4CB = LV_SYMLIST.Items[41].Checked;
            m_Decoder.bIDTAG = LV_SYMLIST.Items[42].Checked;
            m_Decoder.bLABEL = LV_SYMLIST.Items[43].Checked;
            m_Decoder.bGS1_128 = LV_SYMLIST.Items[44].Checked;
            m_Decoder.bHANXIN = LV_SYMLIST.Items[45].Checked;
            m_Decoder.bGRIDMATRIX = LV_SYMLIST.Items[46].Checked;

            m_Imager.SetSymbology(ref m_Decoder);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

        public void SetCheckBox()
        {            
            m_Imager.GetSymbology(out m_Decoder);

            BARCODE_ENABLE[0] = m_Decoder.bAZTEC;
            BARCODE_ENABLE[1] = m_Decoder.bCODABAR;
            BARCODE_ENABLE[2] = m_Decoder.bCODE11;
            BARCODE_ENABLE[3] = m_Decoder.bCODE128;
            BARCODE_ENABLE[4] = m_Decoder.bCODE39;
            BARCODE_ENABLE[5] = m_Decoder.bCODE49;
            BARCODE_ENABLE[6] = m_Decoder.bCODE93;
            BARCODE_ENABLE[7] = m_Decoder.bCOMPOSITE;
            BARCODE_ENABLE[8] = m_Decoder.bDATAMATRIX;
            BARCODE_ENABLE[9] = m_Decoder.bEAN8;
            BARCODE_ENABLE[10] = m_Decoder.bEAN13;
            BARCODE_ENABLE[11] = m_Decoder.bINT25;
            BARCODE_ENABLE[12] = m_Decoder.bMAXICODE;
            BARCODE_ENABLE[13] = m_Decoder.bMICROPDF;
            BARCODE_ENABLE[14] = m_Decoder.bOCR;
            BARCODE_ENABLE[15] = m_Decoder.bPDF417;
            BARCODE_ENABLE[16] = m_Decoder.bPOSTNET;
            BARCODE_ENABLE[17] = m_Decoder.bQR;
            BARCODE_ENABLE[18] = m_Decoder.bRSS;
            BARCODE_ENABLE[19] = m_Decoder.bUPCA;
            BARCODE_ENABLE[20] = m_Decoder.bUPCE;
            BARCODE_ENABLE[21] = m_Decoder.bISBT;
            BARCODE_ENABLE[22] = m_Decoder.bBPO;
            BARCODE_ENABLE[23] = m_Decoder.bCANPOST;
            BARCODE_ENABLE[24] = m_Decoder.bAUSPOST;
            BARCODE_ENABLE[25] = m_Decoder.bIATA25;
            BARCODE_ENABLE[26] = m_Decoder.bCODABLOCK;
            BARCODE_ENABLE[27] = m_Decoder.bJAPOST;
            BARCODE_ENABLE[28] = m_Decoder.bPLANET;
            BARCODE_ENABLE[29] = m_Decoder.bDUTCHPOST;
            BARCODE_ENABLE[30] = m_Decoder.bMSI;
            BARCODE_ENABLE[31] = m_Decoder.bTLCODE39;                        
            BARCODE_ENABLE[32] = m_Decoder.bSTRT25;
            BARCODE_ENABLE[33] = m_Decoder.bMATRIX25;
            BARCODE_ENABLE[34] = m_Decoder.bPLESSEY;
            BARCODE_ENABLE[35] = m_Decoder.bCHINAPOST;
            BARCODE_ENABLE[36] = m_Decoder.bKOREAPOST;
            BARCODE_ENABLE[37] = m_Decoder.bTELEPEN;
            BARCODE_ENABLE[38] = m_Decoder.bCODE16K;
            BARCODE_ENABLE[39] = m_Decoder.bPOSICODE;
            BARCODE_ENABLE[40] = m_Decoder.bCOUPONCODE;
            BARCODE_ENABLE[41] = m_Decoder.bUSPS4CB;
            BARCODE_ENABLE[42] = m_Decoder.bIDTAG;
            BARCODE_ENABLE[43] = m_Decoder.bLABEL;
            BARCODE_ENABLE[44] = m_Decoder.bGS1_128;
            BARCODE_ENABLE[45] = m_Decoder.bHANXIN;
            BARCODE_ENABLE[46] = m_Decoder.bGRIDMATRIX;

        }

        private void LV_SYMLIST_ItemActivate(object sender, EventArgs e)
        {
            switch (LV_SYMLIST.FocusedItem.Index)
            {
                case AZTEC:
                case CODE128:
                case CODE49:
                case CODE93:
                case DATAMATRIX:
                case MAXICODE:
                case MICROPDF:
                case PDF417:
                case QR:
                case IATA25:
                case CODABLOCK:
                case STRT25:
                case MATRIX25:
                case PLESSEY:
                case CHINAPOST:
                case KOREAPOST:
                case CODE16K:
                    LB_MIN.Enabled = true;
                    LB_MAX.Enabled = true;
                    TB_MINLEN.Enabled = true;
                    TB_MAXLEN.Enabled = true;
                    BTN_APPLY.Enabled = true;
                    BTN_PARAM.Enabled = false;
                    break;

                case CODABAR:
                case CODE11:
                case CODE39:
                case COMPOSITE:
                case INT25:
                case RSS:
                case MSI:
                case TELEPEN:
                case POSICODE:
                    LB_MIN.Enabled = true;
                    LB_MAX.Enabled = true;
                    TB_MINLEN.Enabled = true;
                    TB_MAXLEN.Enabled = true;
                    BTN_APPLY.Enabled = true;
                    BTN_PARAM.Enabled = true;
                    break;

                case EAN8:
                case EAN13:
                case POSTNET:
                case UPCA:
                case UPCE:
                case PLANET:
                case OCR:
                    LB_MIN.Enabled = false;
                    LB_MAX.Enabled = false;
                    TB_MINLEN.Enabled = false;
                    TB_MAXLEN.Enabled = false;
                    BTN_APPLY.Enabled = false;
                    BTN_PARAM.Enabled = true;
                    break;

                case ISBT:
                case BPO:
                case CANPOST:
                case AUSPOST:
                case JAPOST:
                case DUTCHPOST:
                case TLCODE39:
                case COUPONCODE:
                case USBS4CB:
                case IDTAG:
                case LABEL:
                case GS1_128:
                case HANXIN:
                case GRIDMATRIX:
                    LB_MIN.Enabled = false;
                    LB_MAX.Enabled = false;
                    TB_MINLEN.Enabled = false;
                    TB_MAXLEN.Enabled = false;
                    BTN_APPLY.Enabled = false;
                    BTN_PARAM.Enabled = false;
                    break;
            }

            switch (LV_SYMLIST.FocusedItem.Index)
            {
                case AZTEC:
                    if (m_Imager.GetAZTEC(out m_Aztec) == false)
                        MessageBox.Show("GetAZTEC()");

                    TB_MINLEN.Text = m_Aztec.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Aztec.nMaxLen.ToString();
                    break;

                case CODABAR:
                    if (m_Imager.GetCODABAR(out m_Codabar) == false)
                        MessageBox.Show("GetCODABAR()");
                    TB_MINLEN.Text = m_Codabar.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Codabar.nMaxLen.ToString();
                    break;

                case CODE11:
                    if (m_Imager.GetCODE11(out m_Code11) == false)
                        MessageBox.Show("GetCODE11()");

                    TB_MINLEN.Text = m_Code11.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Code11.nMaxLen.ToString();
                    break;

                case CODE128:
                    if (m_Imager.GetCODE128(out m_Code128) == false)
                        MessageBox.Show("GetCODE128()");

                    TB_MINLEN.Text = m_Code128.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Code128.nMaxLen.ToString();
                    break;

                case CODE39:
                    if (m_Imager.GetCODE39(out m_Code39) == false)
                        MessageBox.Show("GetCODE39()");

                    TB_MINLEN.Text = m_Code39.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Code39.nMaxLen.ToString();
                    break;

                case CODE49:
                    if (m_Imager.GetCODE49(out m_Code49) == false)
                        MessageBox.Show("GetCODE49()");

                    TB_MINLEN.Text = m_Code49.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Code49.nMaxLen.ToString();
                    break;

                case CODE93:
                    if (m_Imager.GetCODE93(out m_Code93) == false)
                        MessageBox.Show("GetCODE93()");

                    TB_MINLEN.Text = m_Code93.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Code93.nMaxLen.ToString();
                    break;

                case COMPOSITE:
                    if (m_Imager.GetCOMPOSITE(out m_Composite) == false)
                        MessageBox.Show("GetCOMPOSITE()");

                    TB_MINLEN.Text = m_Composite.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Composite.nMaxLen.ToString();
                    break;

                case DATAMATRIX:
                    if (m_Imager.GetDATAMATRIX(out m_Datamatrix) == false)
                        MessageBox.Show("GetDATAMATRIX()");

                    TB_MINLEN.Text = m_Datamatrix.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Datamatrix.nMaxLen.ToString();
                    break;


                case INT25:
                    if (m_Imager.GetINT25(out m_Int25) == false)
                        MessageBox.Show("GetINT25()");

                    TB_MINLEN.Text = m_Int25.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Int25.nMaxLen.ToString();
                    break;

                case MAXICODE:
                    if (m_Imager.GetMAXICODE(out m_Maxicode) == false)
                        MessageBox.Show("GetMAXICODE()");

                    TB_MINLEN.Text = m_Maxicode.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Maxicode.nMaxLen.ToString();
                    break;

                case MICROPDF:
                    if (m_Imager.GetMICROPDF(out m_Micropdf) == false)
                        MessageBox.Show("GetMICROPDF()");

                    TB_MINLEN.Text = m_Micropdf.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Micropdf.nMaxLen.ToString();
                    break;

                case PDF417:
                    if (m_Imager.GetPDF417(out m_Pdf417) == false)
                        MessageBox.Show("GetPDF417()");

                    TB_MINLEN.Text = m_Pdf417.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Pdf417.nMaxLen.ToString();
                    break;


                case QR:
                    if (m_Imager.GetQR(out m_Qr) == false)
                        MessageBox.Show("GetQR()");

                    TB_MINLEN.Text = m_Qr.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Qr.nMaxLen.ToString();
                    break;

                case RSS:
                    if (m_Imager.GetRSS(out m_Rss) == false)
                        MessageBox.Show("GetRSS()");

                    TB_MINLEN.Text = m_Rss.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Rss.nMaxLen.ToString();
                    break;


                case IATA25:
                    if (m_Imager.GetIATA25(out m_Iata25) == false)
                        MessageBox.Show("GetIATA25()");

                    TB_MINLEN.Text = m_Iata25.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Iata25.nMaxLen.ToString();
                    break;

                case CODABLOCK:
                    if (m_Imager.GetCODABLOCK(out m_Codablock) == false)
                        MessageBox.Show("GetCODABLOCK()");

                    TB_MINLEN.Text = m_Codablock.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Codablock.nMaxLen.ToString();
                    break;


                case MSI:
                    if (m_Imager.GetMSI(out m_Msi) == false)
                        MessageBox.Show("GetMSI()");

                    TB_MINLEN.Text = m_Msi.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Msi.nMaxLen.ToString();
                    break;

                case STRT25:
                    if (m_Imager.GetSTRT25(out m_Strt25) == false)
                        MessageBox.Show("GetSTRT25()");

                    TB_MINLEN.Text = m_Strt25.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Strt25.nMaxLen.ToString();
                    break;

                case MATRIX25:
                    if (m_Imager.GetMATRIX25(out m_Matrix25) == false)
                        MessageBox.Show("GetMATRIX25()");

                    TB_MINLEN.Text = m_Matrix25.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Matrix25.nMaxLen.ToString();
                    break;

                case PLESSEY:
                    if (m_Imager.GetPLESSEY(out m_Plessey) == false)
                        MessageBox.Show("GetPLESSEY()");

                    TB_MINLEN.Text = m_Plessey.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Plessey.nMaxLen.ToString();
                    break;

                case CHINAPOST:
                    if (m_Imager.GetCHINAPOST(out m_Chinapost) == false)
                        MessageBox.Show("GetCHINAPOST()");

                    TB_MINLEN.Text = m_Chinapost.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Chinapost.nMaxLen.ToString();
                    break;

                case KOREAPOST:
                    if (m_Imager.GetKOREAPOST(out m_Koreapost) == false)
                        MessageBox.Show("GetKOREAPOST()");

                    TB_MINLEN.Text = m_Koreapost.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Koreapost.nMaxLen.ToString();
                    break;

                case TELEPEN:
                    if (m_Imager.GetTELEPEN(out m_Telepen) == false)
                        MessageBox.Show("GetTELEPEN()");

                    TB_MINLEN.Text = m_Telepen.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Telepen.nMaxLen.ToString();
                    break;

                case CODE16K:
                    if (m_Imager.GetCODE16K(out m_Code16k) == false)
                        MessageBox.Show("GetCODE16K()");

                    TB_MINLEN.Text = m_Code16k.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Code16k.nMaxLen.ToString();
                    break;

                case POSICODE:
                    if (m_Imager.GetPOSICODE(out m_Posicode) == false)
                        MessageBox.Show("GetPOSICODE()");

                    TB_MINLEN.Text = m_Posicode.nMinLen.ToString();
                    TB_MAXLEN.Text = m_Posicode.nMaxLen.ToString();
                    break;

                case OCR:
                case EAN8:
                case EAN13:
                case POSTNET:
                case UPCA:
                case UPCE:
                case PLANET:
                case ISBT:
                case BPO:
                case CANPOST:
                case AUSPOST:
                case JAPOST:
                case DUTCHPOST:
                case TLCODE39:
                case COUPONCODE:
                case USBS4CB:
                case IDTAG:
                case LABEL:
                case GS1_128:
                case HANXIN:
                case GRIDMATRIX:
                    TB_MINLEN.Text = Temp.ToString();
                    TB_MAXLEN.Text = Temp.ToString();
                    break;
            }

            if (LV_SYMLIST.FocusedItem.Checked == true)
                LV_SYMLIST.FocusedItem.Checked = false;
            else
                LV_SYMLIST.FocusedItem.Checked = true;
        }

        private void LV_SYMLIST_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (LV_SYMLIST.FocusedItem != null)
            {
                if (!BARCODE_ENABLED[LV_SYMLIST.FocusedItem.Index])
                {
                    LV_SYMLIST.FocusedItem.Selected = false;
                    LV_SYMLIST.FocusedItem.Checked = false;                   
                    
                }
                    
            }
        }

        private void LV_SYMLIST_ItemCheck(object sender, ItemCheckEventArgs e)
        {
            if (!BARCODE_ENABLED[e.Index])
                e.NewValue = CheckState.Unchecked;
        }
    }
}