﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FSCANOPTION : Form
    {
        private Imager m_Imager;
        private DECODER_PARAMS m_DecoderParams;

        public bool m_bSyncMode;

        public FSCANOPTION()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_DecoderParams = new DECODER_PARAMS();
        }

        private void FSCANOPTION_Load(object sender, EventArgs e)
        {
            m_Imager.GetOption(out m_DecoderParams);

            if (m_bSyncMode)
                RD_SYNC.Checked = true;
            else
                RD_ASYNC.Checked = true;

            if (m_DecoderParams.nSound == 1)
                RD_BEEP.Checked = true;
            else if (m_DecoderParams.nSound == 2)
                RD_NONE.Checked = true;
            else
                RD_DEFAULT.Checked = true;

            CB_TIMEOUT.SelectedIndex = m_DecoderParams.nTimeOut - 1;

            if (m_DecoderParams.bCentering == true)
            {
                CB_CENTER.Checked = true;
                BTN_CENTERING.Enabled = true;
            }
            else
            {
                CB_CENTER.Checked = false;
                BTN_CENTERING.Enabled = false;
            }

            CB_VIBRATE.Checked          = m_DecoderParams.bVibrate;
            CB_AIMID.Checked            = m_DecoderParams.bXmitAimID;
            CB_CONTINUE.Checked         = m_DecoderParams.bContinueMode;
            CB_HEX.Checked              = m_DecoderParams.bHexMode;
            CB_LIGHTMODE.SelectedIndex  = m_DecoderParams.nLightMode;

            if (m_Imager.GetDeviceType() == SCAN_DEVICE_TYPE.DEVICE_M3BLACK)
            {
                CB_CENTER.Enabled = false;
                CB_CONTINUE.Enabled = false;
                BTN_DECODE.Enabled = false;
            }

        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            if (RD_SYNC.Checked)
                m_bSyncMode = true;
            else
                m_bSyncMode = false;

            if (RD_BEEP.Checked == true)
                m_DecoderParams.nSound = 1;
            else if (RD_NONE.Checked == true)
                m_DecoderParams.nSound = 2;
            else
                m_DecoderParams.nSound = 0;

            m_DecoderParams.nTimeOut        = CB_TIMEOUT.SelectedIndex + 1;
            m_DecoderParams.bCentering      = CB_CENTER.Checked;
            m_DecoderParams.bVibrate        = CB_VIBRATE.Checked;
            m_DecoderParams.bXmitAimID      = CB_AIMID.Checked;
            m_DecoderParams.bContinueMode   = CB_CONTINUE.Checked;
            m_DecoderParams.bHexMode        = CB_HEX.Checked;
            m_DecoderParams.nLightMode      = CB_LIGHTMODE.SelectedIndex;

            if (m_Imager.GetDeviceType() == SCAN_DEVICE_TYPE.DEVICE_M3BLACK)
                m_DecoderParams.bContinueMode = false;

            m_Imager.SetOption(ref m_DecoderParams);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

        private void BTN_CENTERING_Click(object sender, EventArgs e)
        {
            FCENTERING Centering = new FCENTERING();

            Centering.ShowDialog();
        }

        private void CB_CENTER_Click(object sender, EventArgs e)
        {
            if (CB_CENTER.Checked == true)
                BTN_CENTERING.Enabled = true;
            else
                BTN_CENTERING.Enabled = false;
        }

        private void BTN_DECODE_Click(object sender, EventArgs e)
        {
            FDECODEOPTION DecOptionDlg = new FDECODEOPTION();

            DecOptionDlg.ShowDialog();
        }
    }
}