﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FRSS : Form
    {
        private Imager m_Imager;
        private RSS_PARAMS m_Rss;

        public FRSS()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Rss = new RSS_PARAMS();
        }

        private void FRSS_Load(object sender, EventArgs e)
        {
            m_Imager.GetRSS(out m_Rss);

            CB_ENABLE.Checked = m_Rss.bEnable;
            CB_LIMITED.Checked = m_Rss.bRssLim;
            CB_EXPENDED.Checked = m_Rss.bRssExp;

            TB_MINLEN.Text = m_Rss.nMinLen.ToString();
            TB_MAXLEN.Text = m_Rss.nMaxLen.ToString();

        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Rss.bEnable = CB_ENABLE.Checked;
            m_Rss.bRssLim = CB_LIMITED.Checked;
            m_Rss.bRssExp = CB_EXPENDED.Checked;

            m_Rss.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
            m_Rss.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

            m_Imager.SetRSS(ref m_Rss);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}