﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FPOSICODE : Form
    {
        private Imager m_Imager;
        private POSICODE_PARAMS m_Posicode;

        public FPOSICODE()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Posicode = new POSICODE_PARAMS();
        }

        private void FPOSICODE_Load(object sender, EventArgs e)
        {
            m_Imager.GetPOSICODE(out m_Posicode);

            CB_ENABLE.Checked = m_Posicode.bEnable;
            CB_LIMITED1.Checked = m_Posicode.bPosi_Lim1;
            CB_LIMITED2.Checked = m_Posicode.bPosi_Lim2;

            TB_MINLEN.Text = m_Posicode.nMinLen.ToString();
            TB_MAXLEN.Text = m_Posicode.nMaxLen.ToString();

        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Posicode.bEnable = CB_ENABLE.Checked;
            m_Posicode.bPosi_Lim1 = CB_LIMITED1.Checked;
            m_Posicode.bPosi_Lim2 = CB_LIMITED2.Checked;

            m_Posicode.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
            m_Posicode.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

            m_Imager.SetPOSICODE(ref m_Posicode);

            this.DialogResult = DialogResult.OK;

        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}