﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;


namespace ImagerTestNet
{
    public partial class FPLANET : Form
    {
        private Imager m_Imager;
        private PLANET_PARAMS m_Planet;

        public FPLANET()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Planet = new PLANET_PARAMS();
        }

        private void FPLANET_Load(object sender, EventArgs e)
        {
            m_Imager.GetPLANET(out m_Planet);

            CB_ENABLE.Checked = m_Planet.bEnable;
            CB_XCD.Checked = m_Planet.bXCD;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Planet.bEnable = CB_ENABLE.Checked;
            m_Planet.bXCD = CB_XCD.Checked;

            m_Imager.SetPLANET(ref m_Planet);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}