﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;


namespace ImagerTestNet
{
    public partial class FOCR : Form
    {
        private Imager m_Imager;
        private OCR_PARAMS m_Ocr;

        public FOCR()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Ocr = new OCR_PARAMS();
        }

        private void FOCR_Load(object sender, EventArgs e)
        {
            m_Imager.GetOCR(out m_Ocr);

            CB_ENABLE.Checked = m_Ocr.bEnable;
            CB_MODE.SelectedIndex = m_Ocr.nMode;
            TB_TEMPLATE.Text = m_Ocr.szTemplate;
            TB_GROUPG.Text = m_Ocr.szGroupG;
            TB_GROUPH.Text = m_Ocr.szGroupH;
            TB_CHECKCHAR.Text = m_Ocr.szCheckChar;

        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Ocr.bEnable = CB_ENABLE.Checked;
            m_Ocr.nMode = CB_MODE.SelectedIndex;
            m_Ocr.szTemplate = TB_TEMPLATE.Text;
            m_Ocr.szGroupG = TB_GROUPG.Text;
            m_Ocr.szGroupH = TB_GROUPH.Text;
            m_Ocr.szCheckChar = TB_CHECKCHAR.Text;

            m_Imager.SetOCR(ref m_Ocr);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}