﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FMSI : Form
    {
        private Imager m_Imager;
        private MSI_PARAMS m_Msi;
        
        public FMSI()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Msi = new MSI_PARAMS();
        }

        private void FMSI_Load(object sender, EventArgs e)
        {
            m_Imager.GetMSI(out m_Msi);

            CB_ENABLE.Checked = m_Msi.bEnable;
            CB_XCD.Checked = m_Msi.bXCD;

            TB_MINLEN.Text = m_Msi.nMinLen.ToString();
            TB_MAXLEN.Text = m_Msi.nMaxLen.ToString();
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Msi.bEnable = CB_ENABLE.Checked;
            m_Msi.bXCD = CB_XCD.Checked;

            m_Msi.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
            m_Msi.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

            m_Imager.SetMSI(ref m_Msi);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}