﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FIQTEST : Form
    {
        public Imager m_Imager;

        public FIQTEST()
        {
            InitializeComponent();
        }

        private void FIQTEST_Load(object sender, EventArgs e)
        {
            m_Imager.ImagerDataEvent += new ImagerDataDelegate(OnIQImaging);

            m_Imager.IQInit(PIC_IQ_IMAGE.Handle);
        }

        public void OnIQImaging(object sender, ImagerDataArgs e)
        {
            if (e.ScanData != "")
            {
                TB_IQDATA.Text = e.ScanData;
            }
        }

        private void FIQTEST_Closing(object sender, CancelEventArgs e)
        {
            m_Imager.ImagerDataEvent -= new ImagerDataDelegate(OnIQImaging);

            m_Imager.IQImagingStop();

            m_Imager.IQUnInit();
        }

        private void BN_IQSTART_Click(object sender, EventArgs e)
        {
            m_Imager.IQImagingStart();
        }

        private void BN_IQSTOP_Click(object sender, EventArgs e)
        {
            m_Imager.IQImagingStop();
        }

        private void BN_IQOPTION_Click(object sender, EventArgs e)
        {
            m_Imager.IQImagingStop();

            FIQOPTION IQOption = new FIQOPTION();
            IQOption.ShowDialog();
        }

        private void BN_CLOSE_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
        }

       
    }
}