﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FIQOPTION : Form
    {
        private Imager      m_Imager;
        private IQ_PARAMS   m_IQParams;

        public FIQOPTION()
        {
            InitializeComponent();

            m_Imager    = new Imager();
            m_IQParams  = new IQ_PARAMS();
        }

        private void FIQOPTION_Load(object sender, EventArgs e)
        {
            m_Imager.IQGetOption(out m_IQParams);

            if (m_IQParams.nIQType == 0)
                RD_AZTEC.Checked = true;
            else
                RD_CODE39.Checked = true;

            TB_SAVEFOLDER.Text          = m_IQParams.szSaveFolder;
            CB_SAVEMODE.SelectedIndex   = m_IQParams.nSaveMode;
            TB_FILENAME.Text            = m_IQParams.szFileName;
            TB_SAVEFORMAT.Text          = ".BMP";
            TB_SAVEFORMAT.Enabled       = false;

            if (CB_SAVEMODE.SelectedIndex == 0)
                TB_FILENAME.Enabled = false;
            else
                TB_FILENAME.Enabled = true;
        }

        private void BN_OK_Click(object sender, EventArgs e)
        {
            if (RD_AZTEC.Checked == true)
                m_IQParams.nIQType = 0;
            else
                m_IQParams.nIQType = 1;

            m_IQParams.szSaveFolder = TB_SAVEFOLDER.Text;
            m_IQParams.nSaveMode    = CB_SAVEMODE.SelectedIndex;
            m_IQParams.szFileName   = TB_FILENAME.Text;

            m_Imager.IQSetOption(ref m_IQParams);

            this.DialogResult = DialogResult.OK;
        }

        private void BN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

        private void CB_SAVEMODE_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (CB_SAVEMODE.SelectedIndex == 0)
                TB_FILENAME.Enabled = false;
            else
                TB_FILENAME.Enabled = true;
        }
    }
}