﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FINT25 : Form
    {
        private Imager m_Imager;
        private INT25_PARAMS m_Int25;

        public FINT25()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Int25 = new INT25_PARAMS();
        }

        private void FINT25_Load(object sender, EventArgs e)
        {
            m_Imager.GetINT25(out m_Int25);

            CB_ENABLE.Checked = m_Int25.bEnable;
            CB_CDV.Checked = m_Int25.bCDV;
            CB_XCD.Checked = m_Int25.bXCD;

            TB_MINLEN.Text = m_Int25.nMinLen.ToString();
            TB_MAXLEN.Text = m_Int25.nMaxLen.ToString();
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Int25.bEnable = CB_ENABLE.Checked;
            m_Int25.bCDV = CB_CDV.Checked;
            m_Int25.bXCD = CB_XCD.Checked;

            m_Int25.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
            m_Int25.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

            m_Imager.SetINT25(ref m_Int25);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}