﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FEAN8 : Form
    {
        private Imager m_Imager;
        private EAN8_PARAMS m_Ean8;

        public FEAN8()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Ean8 = new EAN8_PARAMS();
        }

        private void FEAN8_Load(object sender, EventArgs e)
        {
            m_Imager.GetEAN8(out m_Ean8);

            CB_ENABLE.Checked = m_Ean8.bEnable;
            CB_XCD.Checked = m_Ean8.bXCD;
            CB_ADDON.Checked = m_Ean8.bAddOn;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Ean8.bEnable = CB_ENABLE.Checked;
            m_Ean8.bXCD = CB_XCD.Checked;
            m_Ean8.bAddOn = CB_ADDON.Checked;

            m_Imager.SetEAN8(ref m_Ean8);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

      
    }
}