﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FEAN13 : Form
    {
        private Imager m_Imager;
        private EAN13_PARAMS m_Ean13;

        public FEAN13()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Ean13 = new EAN13_PARAMS();
        }

        private void FEAN13_Load(object sender, EventArgs e)
        {
            m_Imager.GetEAN13(out m_Ean13);

            CB_ENABLE.Checked = m_Ean13.bEnable;
            CB_XCD.Checked = m_Ean13.bXCD;
            CB_ADDON.Checked = m_Ean13.bAddOn;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Ean13.bEnable = CB_ENABLE.Checked;
            m_Ean13.bXCD = CB_XCD.Checked;
            m_Ean13.bAddOn = CB_ADDON.Checked;

            m_Imager.SetEAN13(ref m_Ean13);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}