﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FDECODEOPTION : Form
    {
        private Imager m_Imager;
        private DECOPTION_PARAMS m_DecOption;

        public FDECODEOPTION()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_DecOption = new DECOPTION_PARAMS();
        }

        private void FDECODEOPTION_Load(object sender, EventArgs e)
        {
            m_Imager.GetDecOption(out m_DecOption);

            CB_DECODEMODE.SelectedIndex = m_DecOption.nDecodeMode;
            NUD_LINEAR.Value            = m_DecOption.nLinearRange;
            NUD_PRINT.Value             = m_DecOption.nPrintWeight;
            NUD_MAXDECODE.Value         = m_DecOption.nMaxDecode;
            NUD_MAXSEARCH.Value         = m_DecOption.nMaxSearch;
            CB_VIDEO.Checked            = m_DecOption.bVideoReverse;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {

            m_DecOption.nDecodeMode     = CB_DECODEMODE.SelectedIndex;
            m_DecOption.nLinearRange    = (int)NUD_LINEAR.Value;
            m_DecOption.nPrintWeight    = (int)NUD_PRINT.Value;
            m_DecOption.nMaxDecode      = (int)NUD_MAXDECODE.Value;
            m_DecOption.nMaxSearch      = (int)NUD_MAXSEARCH.Value;
            m_DecOption.bVideoReverse   = CB_VIDEO.Checked;

            m_Imager.SetDecOption(ref m_DecOption);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

        
    }
}