﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FCOMPOSITE : Form
    {
        private Imager m_Imager;
        private COMPOSITE_PARAMS m_Composite;

        public FCOMPOSITE()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Composite = new COMPOSITE_PARAMS();
        }

        private void FCOMPOSITE_Load(object sender, EventArgs e)
        {
            m_Imager.GetCOMPOSITE(out m_Composite);

            CB_ENABLE.Checked = m_Composite.bEnable;
            CB_COMPOSITE.Checked = m_Composite.bComposite_Upc;

            TB_MINLEN.Text = m_Composite.nMinLen.ToString();
            TB_MAXLEN.Text = m_Composite.nMaxLen.ToString();
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Composite.bEnable = CB_ENABLE.Checked;
            m_Composite.bComposite_Upc = CB_COMPOSITE.Checked;

            m_Composite.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
            m_Composite.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

            m_Imager.SetCOMPOSITE(ref m_Composite);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}