﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FCODE39 : Form
    {
        private Imager m_Imager;
        private CODE39_PARAMS m_Code39;

        public FCODE39()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Code39 = new CODE39_PARAMS();
        }

        private void FCODE39_Load(object sender, EventArgs e)
        {
            m_Imager.GetCODE39(out m_Code39);

            CB_ENABLE.Checked       = m_Code39.bEnable;
            if (m_Code39.nFormat == 1)
                RD_CODE32.Checked = true;
            else if (m_Code39.nFormat == 2)
                RD_TRIOPTIC.Checked = true;
            else
                RD_STANDARD.Checked = true;
            
            CB_CDV.Checked          = m_Code39.bCDV;
            CB_XCD.Checked          = m_Code39.bXCD;
            CB_FULLASCII.Checked    = m_Code39.bFullASCII;

            TB_MINLEN.Text = m_Code39.nMinLen.ToString();
            TB_MAXLEN.Text = m_Code39.nMaxLen.ToString();
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Code39.bEnable        = CB_ENABLE.Checked;

            if (RD_CODE32.Checked == true)
                m_Code39.nFormat = 1;
            else if (RD_TRIOPTIC.Checked == true)
                m_Code39.nFormat = 2;
            else
                m_Code39.nFormat = 0;
            
            m_Code39.bCDV           = CB_CDV.Checked;
            m_Code39.bXCD           = CB_XCD.Checked;
            m_Code39.bFullASCII     = CB_FULLASCII.Checked;

            m_Code39.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
            m_Code39.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

            m_Imager.SetCODE39(ref m_Code39);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}