﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FCODE11 : Form
    {
        private Imager m_Imager;
        private CODE11_PARAMS m_Code11;

        public FCODE11()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Code11 = new CODE11_PARAMS();
        }

        private void FCODE11_Load(object sender, EventArgs e)
        {
            m_Imager.GetCODE11(out m_Code11);

            CB_ENABLE.Checked = m_Code11.bEnable;
            CB_CDV.Checked = m_Code11.bCDV;

            TB_MINLEN.Text = m_Code11.nMinLen.ToString();
            TB_MAXLEN.Text = m_Code11.nMaxLen.ToString();
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Code11.bEnable = CB_ENABLE.Checked;
            m_Code11.bCDV = CB_CDV.Checked;

            m_Code11.nMinLen = Convert.ToInt32(TB_MINLEN.Text);
            m_Code11.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text);

            m_Imager.SetCODE11(ref m_Code11);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}