﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FCENTERING : Form
    {
        private Imager m_Imager;
        private RECT_PARAM m_Rect;
        public string m_strVersion;

        public FCENTERING()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Rect = new RECT_PARAM();
            m_strVersion = "Rectangular image region of which at least part of the decoded symbol must overlap to be considered a valid decode.\r\n The Validated Range:\r\nLeft Range : 0 -375\r\n   Right Range : 376 - 751\r\n  Top Range : 0 - 239\r\n Bottom Range : 240 - 479";
        }

        private void FCENTERING_Load(object sender, EventArgs e)
        {
            TB_CENTERINGINFO.Text = m_strVersion;
            
            TB_CENTERINGINFO.Enabled = false;

            m_Imager.GetCenteringWindow(out m_Rect);
            TB_BOTTOM.Text = m_Rect.bottom.ToString();
            TB_RIGHT.Text = m_Rect.right.ToString();
            TB_TOP.Text = m_Rect.top.ToString();
            TB_LEFT.Text = m_Rect.left.ToString(); 
            
            
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {

            m_Rect.top = Convert.ToInt32(TB_TOP.Text);
            m_Rect.left = Convert.ToInt32(TB_LEFT.Text);
            m_Rect.right = Convert.ToInt32(TB_RIGHT.Text);
            m_Rect.bottom = Convert.ToInt32(TB_BOTTOM.Text);

            m_Imager.SetCenteringWindow(ref m_Rect);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}