﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FCAMTEST : Form
    {
        public Imager m_Imager;
        public bool m_bPreview = false;

        public FCAMTEST()
        {
            InitializeComponent();
        }

        private void FCAMTEST_Load(object sender, EventArgs e)
        {
            m_Imager.CAMInit(PIC_IMAGE.Handle);

            BN_PRESTOP.Enabled = false;
            BN_CAPTURE.Enabled = false;
        }

        private void BN_PRESTART_Click(object sender, EventArgs e)
        {
            BN_PRESTART.Enabled = false;
            BN_PRESTOP.Enabled = true;
            BN_CAPTURE.Enabled = true;
            BN_CAMOPTION.Enabled = false;
            BN_CLOSE.Enabled = false;

            m_Imager.CAMPreviewStart();
            m_bPreview = true;
        }

        private void BN_PRESTOP_Click(object sender, EventArgs e)
        {
            BN_PRESTART.Enabled = true;
            BN_PRESTOP.Enabled = false;
            BN_CAPTURE.Enabled = false;
            BN_CAMOPTION.Enabled = true;
            BN_CLOSE.Enabled = true;

            m_Imager.CAMPreviewStop();
            m_bPreview = false;
        }

        private void BN_CAPTURE_Click(object sender, EventArgs e)
        {
            m_Imager.CAMCapture();
        }

        private void BN_CAMOPTION_Click(object sender, EventArgs e)
        {
            FCAMOPTION CamOption = new FCAMOPTION();

            CamOption.ShowDialog();
        }

        private void BN_CLOSE_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
        }

        private void FCAMTEST_Closing(object sender, CancelEventArgs e)
        {
            if (m_bPreview == true)
                m_Imager.CAMPreviewStop();

            m_Imager.CAMUnInit();
        }
    }
}