﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ImagerNet;

namespace ImagerTestNet
{
    public partial class FCAMOPTION : Form
    {
        private Imager      m_Imager;
        private CAM_PARAMS  m_CamParams;

        public FCAMOPTION()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_CamParams = new CAM_PARAMS();
        }

        private void FCAMOPTION_Load(object sender, EventArgs e)
        {
            m_Imager.CAMGetOption(out m_CamParams);

            if (m_CamParams.nSaveFormat == 0)
                RD_JPG.Checked = true;
            else
                RD_BMP.Checked = true;

            NUD_JPEGQUALITY.Value       = m_CamParams.nJpegQuality;
            CB_RESOLUTION.SelectedIndex = m_CamParams.nResolution;
            TB_SAVEFOLDER.Text          = m_CamParams.szSaveFolder;
            CB_SAVEMODE.SelectedIndex   = m_CamParams.nSaveMode;
            TB_FILENAME.Text            = m_CamParams.szFileName;

            if (RD_JPG.Checked == true)
                TB_SAVEFORMAT.Text = ".JPG";
            else
                TB_SAVEFORMAT.Text = ".BMP";

            if (CB_SAVEMODE.SelectedIndex == 0)
                TB_FILENAME.Enabled = false;
            else
                TB_FILENAME.Enabled = true;

            TB_SAVEFORMAT.Enabled = false; 
      
        }

        private void BN_OK_Click(object sender, EventArgs e)
        {
            if(RD_JPG.Checked == true)
                m_CamParams.nSaveFormat = 0;
            else
                m_CamParams.nSaveFormat = 1;

            m_CamParams.nJpegQuality    = (int)NUD_JPEGQUALITY.Value;
            m_CamParams.nResolution     = CB_RESOLUTION.SelectedIndex;
            m_CamParams.szSaveFolder    = TB_SAVEFOLDER.Text;
            m_CamParams.nSaveMode       = CB_SAVEMODE.SelectedIndex;
            m_CamParams.szFileName      = TB_FILENAME.Text;

            m_Imager.CAMSetOption(ref m_CamParams);

            this.DialogResult = DialogResult.OK;
        }

        private void BN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }       

        private void CB_SAVEMODE_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (CB_SAVEMODE.SelectedIndex == 0)
                TB_FILENAME.Enabled = false;
            else
                TB_FILENAME.Enabled = true;
        }

        private void RD_JPG_Click(object sender, EventArgs e)
        {
            TB_SAVEFORMAT.Text = ".JPG";
        }

        private void RD_BMP_Click(object sender, EventArgs e)
        {
            TB_SAVEFORMAT.Text = ".BMP";
        }
    }
}