#define IMAGER_API __declspec(dllexport)

#define	WM_SCAN_DATA			WM_APP + 350
#define	WM_IQ_DATA				WM_APP + 380

typedef enum {
	DEVICE_M3SKY = 0,
	DEVICE_M3SKYSAM,
	DEVICE_MM3,
	DEVICE_M3ORANGE,
	DEVICE_M3SMART_CE,
	DEVICE_M3SMART_WM,
	DEVICE_M3GREEN,
	DEVICE_M3T,
	DEVICE_M3POS,
	DEVICE_M3ORANGEPLUS,
	DEVICE_M3ORANGEPLUS_CE,
	DEVICE_M3BLACK,
	DEVICE_M3UL10_CE,
	DEVICE_M3TPLUS_CE,
	DEVICE_M3BLACK_CE,
	DEVICE_UNKNOWN 
} SCAN_DEVICE_TYPE;

typedef enum {
	SOUND_DEFAULT = 0,
	SOUND_BEEP,
	SOUND_NONE
} SCAN_SOUND;

typedef enum
{
	CODE39_STANDARD = 0, 
	CODE39_CODE32,
	CODE39_TRIOPTIC	
}CODE39_FORMAT;

typedef enum
{
	MODE_OCR_DISABLED = 0,
	MODE_OCR_A,
	MODE_OCR_B,
	MODE_OCR_MONEY,
	MODE_OCR_MICR_UNSUPPORTED,
}OCR_MODE;

typedef enum {
	DECODE_STANDARD = 0,
	DECODE_QUICK_OMNI,
	DECODE_LINEAR_PRIORITY
} DECODEMODE;

typedef enum {
	CAM_FULL_RESOLUTION = 0,
	CAM_HALF_RESOLUTION,
	CAM_QUARTER_RESOLUTION
} CAM_RESOLUTION;

typedef enum {
	CAM_JPG = 0,
	CAM_BMP,
} CAM_FORMAT;

typedef enum {
	SAVE_DATE = 0,
	SAVE_CUSTOM_WITH_NUM,
	SAVE_CUSTOM
} SAVE_MODE;

typedef enum {
	IQ_AZTEC = 0,
	IQ_CODE39
} IQ_TYPE;

typedef struct _DECODER{

	// Symbology 47
	BYTE bAZTEC;
	BYTE bCODABAR;
	BYTE bCODE11;
	BYTE bCODE128;
	BYTE bCODE39;
	BYTE bCODE49;
	BYTE bCODE93;
	BYTE bCOMPOSITE;
	BYTE bDATAMATRIX;
	BYTE bEAN8;
	BYTE bEAN13;
	BYTE bINT25;
	BYTE bMAXICODE;
	BYTE bMICROPDF;
	BYTE bOCR;
	BYTE bPDF417;
	BYTE bPOSTNET;
	BYTE bQR;
	BYTE bRSS;
	BYTE bUPCA;
	BYTE bUPCE;	
	BYTE bISBT;
	BYTE bBPO;
	BYTE bCANPOST;
	BYTE bAUSPOST;
	BYTE bIATA25;
	BYTE bCODABLOCK;
	BYTE bJAPOST;
	BYTE bPLANET;
	BYTE bDUTCHPOST;
	BYTE bMSI;
	BYTE bTLCODE39;
	BYTE bSTRT25;
	BYTE bMATRIX25;
	BYTE bPLESSEY;
	BYTE bCHINAPOST;
	BYTE bKOREAPOST;
	BYTE bTELEPEN;
	BYTE bCODE16K;
	BYTE bPOSICODE;
	BYTE bCOUPONCODE;
	BYTE bUSPS4CB;
	BYTE bIDTAG;
	BYTE bLABEL;
	BYTE bGS1_128;
	BYTE bHANXIN;
	BYTE bGRIDMATRIX;

}DECODER, *PDECODER;

typedef struct _DECODER_PARAMS{
	BYTE bCentering;	
	BYTE bContinueMode;
	BYTE bXmitAimID;
	BYTE bHexMode;
	BYTE bVibrate;	
	int	 nSound;
	int	 nTimeOut;
	int	 nLightMode;	
}DECODER_PARAMS, *PDECODER_PARAMS;

typedef struct _DECOPTION_PARAMS{
	int	 nDecodeMode;	
	int	 nLinearRange;	
	int	 nPrintWeight;			
	int	 nMaxDecode;  
	int	 nMaxSearch;		
	BOOL bVideoReverse;	
}DECOPTION_PARAMS, *PDECOPTION_PARAMS;

typedef struct _CAM_PARAMS{
	int		nSaveMode;
	int		nSaveFormat;		
	int		nJpegQuality;		
	int		nResolution;
	TCHAR	szSaveFolder[256];
	TCHAR	szFileName[256];
} CAM_PARAMS, *PCAM_PARAMS;

typedef struct _IQ_PARAMS{
	int		nSaveMode;
	int		nIQType;
	TCHAR	szSaveFolder[256];
	TCHAR	szFileName[256];
} IQ_PARAMS, *PIQ_PARAMS;

typedef struct _AZTEC_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}AZTEC_PARAMS, *PAZTEC_PARAMS;

typedef struct _CODABAR_PARAMS{
	BYTE	bEnable;
	BYTE	bCDV;
	BYTE	bXCD;
	BYTE	bXSS;
	int 	nMinLen;
	int 	nMaxLen;
}CODABAR_PARAMS, *PCODABAR_PARAMS;

typedef struct _CODE11_PARAMS{
	BYTE	bEnable;
	BYTE	bCDV;
	int 	nMinLen;
	int 	nMaxLen;
}CODE11_PARAMS, *PCODE11_PARAMS;

typedef struct _CODE128_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}CODE128_PARAMS, *PCODE128_PARAMS;

typedef struct _CODE39_PARAMS{
	BYTE	bEnable;
	int		nFormat;	
	BYTE	bCDV;
	BYTE	bXCD;
	BYTE	bFullASCII;
	int 	nMinLen;
	int 	nMaxLen;
}CODE39_PARAMS, *PCODE39_PARAMS;

typedef struct _CODE49_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}CODE49_PARAMS, *PCODE49_PARAMS;

typedef struct _CODE93_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}CODE93_PARAMS, *PCODE93_PARAMS;

typedef struct _COMPOSITE_PARAMS{
	BYTE	bEnable;
	BYTE	bComposite_Upc;
	int 	nMinLen;
	int 	nMaxLen;
}COMPOSITE_PARAMS, *PCOMPOSITE_PARAMS;

typedef struct _DATAMATRIX_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}DATAMATRIX_PARAMS, *PDATAMATRIX_PARAMS;

typedef struct _EAN8_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
	BYTE	bAddOn;
}EAN8_PARAMS, *PEAN8_PARAMS;

typedef struct _EAN13_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
	BYTE	bAddOn;
}EAN13_PARAMS, *PEAN13_PARAMS;

typedef struct _INT25_PARAMS{
	BYTE	bEnable;
	BYTE	bCDV;
	BYTE	bXCD;
	int 	nMinLen;
	int 	nMaxLen;
}INT25_PARAMS, *PINT25_PARAMS;

typedef struct _MAXICODE_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}MAXICODE_PARAMS, *PMAXICODE_PARAMS;

typedef struct _MICROPDF_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}MICROPDF_PARAMS, *PMICROPDF_PARAMS;

typedef struct _OCR_PARAMS{
	BYTE		bEnable;
	OCR_MODE	nMode;
	TCHAR		szTemplate[256];
	TCHAR		szGroupG[256];
	TCHAR		szGroupH[256];
	TCHAR		szCheckChar[64];	
}OCR_PARAMS, *POCR_PARAMS;

typedef struct _PDF417_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}PDF417_PARAMS, *PPDF417_PARAMS;

typedef struct _POSTNET_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;	
}POSTNET_PARAMS, *PPOSTNET_PARAMS;

typedef struct _QR_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}QR_PARAMS, *PQR_PARAMS;

typedef struct _RSS_PARAMS{
	BYTE	bEnable;
	BYTE	bRssLim;
	BYTE	bRssExp;
	int 	nMinLen;
	int 	nMaxLen;
}RSS_PARAMS, *PRSS_PARAMS;

typedef struct _UPCA_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
	BYTE	bXNum;
	BYTE	bAddOn;
}UPCA_PARAMS, *PUPCA_PARAMS;

typedef struct _UPCE_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
	BYTE	bXNum;
	BYTE	bAddOn;
}UPCE_PARAMS, *PUPCE_PARAMS;

typedef struct _IATA25_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}IATA25_PARAMS, *PIATA25_PARAMS;

typedef struct _CODABLOCK_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}CODABLOCK_PARAMS, *PCODABLOCK_PARAMS;

typedef struct _PLANET_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
}PLANET_PARAMS, *PPLANET_PARAMS;

typedef struct _MSI_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
	int 	nMinLen;
	int 	nMaxLen;
}MSI_PARAMS, *PMSI_PARAMS;

typedef struct _STRT25_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}STRT25_PARAMS, *PSTRT25_PARAMS;

typedef struct _MATRIX25_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}MATRIX25_PARAMS, *PMATRIX25_PARAMS;

typedef struct _PLESSEY_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}PLESSEY_PARAMS, *PPLESSEY_PARAMS;

typedef struct _CHINAPOST_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}CHINAPOST_PARAMS, *PCHINAPOST_PARAMS;

typedef struct _KOREAPOST_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}KOREAPOST_PARAMS, *PKOREAPOST_PARAMS;

typedef struct _TELEPEN_PARAMS{
	BYTE	bEnable;
	BYTE	bNumeric;
	int 	nMinLen;
	int 	nMaxLen;
}TELEPEN_PARAMS, *PTELEPEN_PARAMS;

typedef struct _CODE16K_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}CODE16K_PARAMS, *PCODE16K_PARAMS;

typedef struct _POSICODE_PARAMS{
	BYTE	bEnable;
	BYTE	bPosi_Lim1;
	BYTE	bPosi_Lim2;
	int 	nMinLen;
	int 	nMaxLen;
}POSICODE_PARAMS, *PPOSICODE_PARAMS;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

	// Decoding
	IMAGER_API BOOL IMAGER_Open();
	IMAGER_API BOOL IMAGER_Close();
	IMAGER_API BOOL IMAGER_Read();
	IMAGER_API BOOL IMAGER_ReadCancel();
	IMAGER_API BOOL IMAGER_GetScanData(TCHAR *szBarType, TCHAR *szBarData);
	IMAGER_API BOOL IMAGER_GetScanByteData(BYTE *pbyBarType, BYTE *pbyBarData, int *pnLength);
	IMAGER_API BOOL IMAGER_GetVersionInfo(TCHAR* szVersion);
	IMAGER_API SCAN_DEVICE_TYPE  IMAGER_GetDeviceType();

	IMAGER_API BOOL IMAGER_SetOption(PDECODER_PARAMS pOption);
	IMAGER_API BOOL IMAGER_GetOption(PDECODER_PARAMS pOption);
	IMAGER_API BOOL IMAGER_SetDecOption(PDECOPTION_PARAMS pDecOption);
	IMAGER_API BOOL IMAGER_GetDecOption(PDECOPTION_PARAMS pDecOption);
	IMAGER_API BOOL IMAGER_SetCenteringWindow(RECT* pRect);
	IMAGER_API BOOL IMAGER_GetCenteringWindow(RECT* pRect);
	IMAGER_API BOOL IMAGER_SetSymbologyAll();
	IMAGER_API BOOL IMAGER_SetSymbologyDefault();
	IMAGER_API BOOL IMAGER_SetSymbology(PDECODER pSymbology);
	IMAGER_API BOOL IMAGER_GetSymbology(PDECODER pSymbology);

	IMAGER_API BOOL IMAGER_SetAZTEC(PAZTEC_PARAMS pAztec);
	IMAGER_API BOOL IMAGER_GetAZTEC(PAZTEC_PARAMS pAztec);
	IMAGER_API BOOL IMAGER_SetCODABAR(PCODABAR_PARAMS pCodabar);
	IMAGER_API BOOL IMAGER_GetCODABAR(PCODABAR_PARAMS pCodabar);
	IMAGER_API BOOL IMAGER_SetCODE11(PCODE11_PARAMS pCode11);
	IMAGER_API BOOL IMAGER_GetCODE11(PCODE11_PARAMS pCode11);
	IMAGER_API BOOL IMAGER_SetCODE128(PCODE128_PARAMS pCode128);
	IMAGER_API BOOL IMAGER_GetCODE128(PCODE128_PARAMS pCode128);
	IMAGER_API BOOL IMAGER_SetCODE39(PCODE39_PARAMS pCode39);
	IMAGER_API BOOL IMAGER_GetCODE39(PCODE39_PARAMS pCode39);
	IMAGER_API BOOL IMAGER_SetCODE49(PCODE49_PARAMS pCode49);
	IMAGER_API BOOL IMAGER_GetCODE49(PCODE49_PARAMS pCode49);
	IMAGER_API BOOL IMAGER_SetCODE93(PCODE93_PARAMS pCode93);
	IMAGER_API BOOL IMAGER_GetCODE93(PCODE93_PARAMS pCode93);
	IMAGER_API BOOL IMAGER_SetCOMPOSITE(PCOMPOSITE_PARAMS pComposite);
	IMAGER_API BOOL IMAGER_GetCOMPOSITE(PCOMPOSITE_PARAMS pComposite);
	IMAGER_API BOOL IMAGER_SetDATAMATRIX(PDATAMATRIX_PARAMS pDataMatrix);
	IMAGER_API BOOL IMAGER_GetDATAMATRIX(PDATAMATRIX_PARAMS pDataMatirx);
	IMAGER_API BOOL IMAGER_SetEAN8(PEAN8_PARAMS pEan8);
	IMAGER_API BOOL IMAGER_GetEAN8(PEAN8_PARAMS pEan8);
	IMAGER_API BOOL IMAGER_SetEAN13(PEAN13_PARAMS pEan13);
	IMAGER_API BOOL IMAGER_GetEAN13(PEAN13_PARAMS pEan13);
	IMAGER_API BOOL IMAGER_SetINT25(PINT25_PARAMS pInt25);
	IMAGER_API BOOL IMAGER_GetINT25(PINT25_PARAMS pInt25);
	IMAGER_API BOOL IMAGER_SetMAXICODE(PMAXICODE_PARAMS pMaxiCode);
	IMAGER_API BOOL IMAGER_GetMAXICODE(PMAXICODE_PARAMS pMaxiCode);
	IMAGER_API BOOL IMAGER_SetMICROPDF(PMICROPDF_PARAMS pMicroPdf);
	IMAGER_API BOOL IMAGER_GetMICROPDF(PMICROPDF_PARAMS pMicroPdf);
	IMAGER_API BOOL IMAGER_SetOCR(POCR_PARAMS pOcr);
	IMAGER_API BOOL IMAGER_GetOCR(POCR_PARAMS pOcr);
	IMAGER_API BOOL IMAGER_SetPDF417(PPDF417_PARAMS pPdf417);
	IMAGER_API BOOL IMAGER_GetPDF417(PPDF417_PARAMS pPdf417);
	IMAGER_API BOOL IMAGER_SetPOSTNET(PPOSTNET_PARAMS pPostNet);
	IMAGER_API BOOL IMAGER_GetPOSTNET(PPOSTNET_PARAMS pPostNet);
	IMAGER_API BOOL IMAGER_SetQR(PQR_PARAMS pQr);
	IMAGER_API BOOL IMAGER_GetQR(PQR_PARAMS pQr);
	IMAGER_API BOOL IMAGER_SetRSS(PRSS_PARAMS pRss);
	IMAGER_API BOOL IMAGER_GetRSS(PRSS_PARAMS pRss);
	IMAGER_API BOOL IMAGER_SetUPCA(PUPCA_PARAMS pUpca);
	IMAGER_API BOOL IMAGER_GetUPCA(PUPCA_PARAMS pUpca);
	IMAGER_API BOOL IMAGER_SetUPCE(PUPCE_PARAMS pUpce);
	IMAGER_API BOOL IMAGER_GetUPCE(PUPCE_PARAMS pUpce);
	IMAGER_API BOOL IMAGER_SetIATA25(PIATA25_PARAMS pIata25);
	IMAGER_API BOOL IMAGER_GetIATA25(PIATA25_PARAMS pIata25);
	IMAGER_API BOOL IMAGER_SetCODABLOCK(PCODABLOCK_PARAMS pCodablock);
	IMAGER_API BOOL IMAGER_GetCODABLOCK(PCODABLOCK_PARAMS pCodablock);
	IMAGER_API BOOL IMAGER_SetPLANET(PPLANET_PARAMS pPlanet);
	IMAGER_API BOOL IMAGER_GetPLANET(PPLANET_PARAMS pPlanet);
	IMAGER_API BOOL IMAGER_SetMSI(PMSI_PARAMS pMsi);
	IMAGER_API BOOL IMAGER_GetMSI(PMSI_PARAMS pMsi);
	IMAGER_API BOOL IMAGER_SetSTRT25(PSTRT25_PARAMS pStrt25);
	IMAGER_API BOOL IMAGER_GetSTRT25(PSTRT25_PARAMS pStrt25);
	IMAGER_API BOOL IMAGER_SetMATRIX25(PMATRIX25_PARAMS pMatrix25);
	IMAGER_API BOOL IMAGER_GetMATRIX25(PMATRIX25_PARAMS pMatrix25);
	IMAGER_API BOOL IMAGER_SetPLESSEY(PPLESSEY_PARAMS pPlessey);
	IMAGER_API BOOL IMAGER_GetPLESSEY(PPLESSEY_PARAMS pPlessey);
	IMAGER_API BOOL IMAGER_SetCHINAPOST(PCHINAPOST_PARAMS pChinaPost);
	IMAGER_API BOOL IMAGER_GetCHINAPOST(PCHINAPOST_PARAMS pChinaPost);
	IMAGER_API BOOL IMAGER_SetKOREAPOST(PKOREAPOST_PARAMS pKoreaPost);
	IMAGER_API BOOL IMAGER_GetKOREAPOST(PKOREAPOST_PARAMS pKoreaPost);
	IMAGER_API BOOL IMAGER_SetTELEPEN(PTELEPEN_PARAMS pTelepen);
	IMAGER_API BOOL IMAGER_GetTELEPEN(PTELEPEN_PARAMS pTelepen);
	IMAGER_API BOOL IMAGER_SetCODE16K(PCODE16K_PARAMS pCode16k);
	IMAGER_API BOOL IMAGER_GetCODE16K(PCODE16K_PARAMS pCode16k);
	IMAGER_API BOOL IMAGER_SetPOSICODE(PPOSICODE_PARAMS pPosiCode);
	IMAGER_API BOOL IMAGER_GetPOSICODE(PPOSICODE_PARAMS pPosiCode);

	// Imaging
	IMAGER_API BOOL IMAGER_CAMInit(HWND hPictureWnd);
	IMAGER_API BOOL IMAGER_CAMUnInit();
	IMAGER_API BOOL IMAGER_CAMPreviewStart();
	IMAGER_API BOOL IMAGER_CAMPreviewStop();
	IMAGER_API BOOL IMAGER_CAMCapture();
	IMAGER_API BOOL IMAGER_CAMSetOption(PCAM_PARAMS pCamOption);
	IMAGER_API BOOL IMAGER_CAMGetOption(PCAM_PARAMS pCamOption);

	// IQ Imaging
	IMAGER_API BOOL IMAGER_IQInit(HWND hPictureWnd);
	IMAGER_API BOOL IMAGER_IQUnInit();
	IMAGER_API BOOL IMAGER_IQImagingStart();
	IMAGER_API BOOL IMAGER_IQImagingStop();
	IMAGER_API BOOL IMAGER_IQGetBarcodeData(TCHAR *szBarData);
	IMAGER_API BOOL IMAGER_IQSetOption(PIQ_PARAMS pIQOption);
	IMAGER_API BOOL IMAGER_IQGetOption(PIQ_PARAMS pIQOption);

#ifdef __cplusplus
}
#endif // __cplusplus

