// ViewerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "ViewerDlg.h"
#include "ImagerTestDlg.h"
///////////////////////////////
//	̹ 
#include <initguid.h>
#include <imaging.h>
#pragma comment (lib, "ole32.lib")
//////////////////////////////////////


// CViewerDlg dialog

IMPLEMENT_DYNAMIC(CViewerDlg, CDialog)

CViewerDlg::CViewerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CViewerDlg::IDD, pParent)
{

}

CViewerDlg::~CViewerDlg()
{
}

void CViewerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATIC_VIEWER, m_ctrlStaticViewer);
}


BEGIN_MESSAGE_MAP(CViewerDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_LEFT, &CViewerDlg::OnBnClickedBtnLeft)
	ON_BN_CLICKED(IDC_BTN_RIGHT, &CViewerDlg::OnBnClickedBtnRight)
END_MESSAGE_MAP()


BOOL CViewerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	FindImageFiles();

	return TRUE;  
}

void CViewerDlg::OnBnClickedBtnLeft()
{
	if(m_FileList.GetHeadPosition() != m_ListPos)
		m_FileList.GetPrev(m_ListPos);
	else
		m_ListPos = m_FileList.GetTailPosition();

	LoadImageViewer(m_FileList.GetAt(m_ListPos));
}

void CViewerDlg::OnBnClickedBtnRight()
{
	if(m_FileList.GetTailPosition() != m_ListPos)
		m_FileList.GetNext(m_ListPos);
	else
		m_ListPos = m_FileList.GetHeadPosition();

	LoadImageViewer(m_FileList.GetAt(m_ListPos));
}

void CViewerDlg::FindImageFiles(void)
{
	PCAM_PARAMS pCamOption = new CAM_PARAMS();

	IMAGER_CAMGetOption(pCamOption);
	

	TCHAR	szFileFullName[MAX_PATH];
	TCHAR	szFilePath[256] = {0, };
	PTCHAR	pFileName	= NULL;

	while(!m_FileList.IsEmpty())
	{
		delete (m_FileList.RemoveTail());
	}

	memcpy(szFilePath, pCamOption->szSaveFolder, 256);

	wcscat(szFilePath, L"\\*.*");

	m_hFind = FindFirstFile(szFilePath,&m_FD);
	if(m_hFind == INVALID_HANDLE_VALUE)
	{		
		::MessageBox(NULL,L"Error : Not Image Files", NULL, MB_TOPMOST);
		return;
	}

	do
	{	
		if(!(m_FD.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))		
		{	
			if((wcsstr(m_FD.cFileName, L".bmp") != NULL) || (wcsstr(m_FD.cFileName, L".jpg") != NULL))	// 2:
			{	 	
				wcscpy(szFileFullName, pCamOption->szSaveFolder);
				wcscat(szFileFullName, L"\\");
				wcscat(szFileFullName, m_FD.cFileName);

				pFileName = new TCHAR[sizeof(TCHAR) * wcslen(szFileFullName) + 1];
				wcscpy(pFileName, szFileFullName);
				m_FileList.AddTail(pFileName);
			}
		}			
	}while(FindNextFile(m_hFind, &m_FD));

	if(m_FileList.IsEmpty())
	{
		::MessageBox(NULL,L"Error : Not Image Files", NULL, MB_TOPMOST);
		return;
	}	

	m_ListPos = m_FileList.GetTailPosition();	

	delete pCamOption;
}

void CViewerDlg::LoadImageViewer(PTCHAR szFileName)
{
	CViewerDlg ViewDlg;

	RECT				rect;
	HRESULT				hr;
	HDC					hDCmem;
	CDC					*hWndDC;	
	IImage				*pImage = NULL;
	IImagingFactory		*pImagingFactory = NULL;

	hWndDC = m_ctrlStaticViewer.GetDC();
	m_ctrlStaticViewer.GetClientRect(&rect);

	hDCmem = CreateCompatibleDC(hWndDC->m_hDC);

	hr = CoCreateInstance(CLSID_ImagingFactory, NULL, CLSCTX_INPROC_SERVER, IID_IImagingFactory, (void**) &pImagingFactory);
	if (FAILED(hr)) 
		goto finish;

	hr = pImagingFactory->CreateImageFromFile(szFileName, &pImage);
	if (FAILED(hr) || pImage == NULL)   
		goto finish;

	hr = pImage->Draw(hWndDC->m_hDC, &rect, NULL);

finish:

	if (pImage)                 
		pImage->Release();

	if (pImagingFactory)    
		pImagingFactory->Release();

	DeleteDC(hDCmem);

	m_ctrlStaticViewer.ReleaseDC(hWndDC);
}
