// UpceDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "UpceDlg.h"
#include "ImagerTestDlg.h"


// CUpceDlg dialog

IMPLEMENT_DYNAMIC(CUpceDlg, CDialog)

CUpceDlg::CUpceDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUpceDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXCD(FALSE)
	, m_bXNum(FALSE)
	, m_bAddOn(FALSE)
{
	
}

CUpceDlg::~CUpceDlg()
{
	
}

void CUpceDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_XNUM, m_bXNum);
	DDX_Check(pDX, IDC_CHECK_ADDON, m_bAddOn);
}


BEGIN_MESSAGE_MAP(CUpceDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CUpceDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CUpceDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
	
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PUPCE_PARAMS pUpce = new UPCE_PARAMS();

	if(IMAGER_GetUPCE(pUpce) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetUPCE()", NULL, MB_TOPMOST);

	m_bEnable	= pUpce->bEnable;
	m_bXCD		= pUpce->bXCD;
	m_bXNum		= pUpce->bXNum;
	m_bAddOn	= pUpce->bAddOn;

	delete pUpce;

	UpdateData(FALSE);

	return TRUE;  
}

void CUpceDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PUPCE_PARAMS pUpce = new UPCE_PARAMS();

	pUpce->bEnable	= m_bEnable;
	pUpce->bXCD		= m_bXCD;
	pUpce->bXNum	= m_bXNum;
	pUpce->bAddOn	= m_bAddOn;

	if(IMAGER_SetUPCE(pUpce) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetUPCE()", NULL, MB_TOPMOST);

	delete pUpce;

	OnOK();
}
