// UpcaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "UpcaDlg.h"
#include "ImagerTestDlg.h"


// CUpcaDlg dialog

IMPLEMENT_DYNAMIC(CUpcaDlg, CDialog)

CUpcaDlg::CUpcaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUpcaDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXCD(FALSE)
	, m_bXNum(FALSE)
	, m_bAddOn(FALSE)
{
	
}

CUpcaDlg::~CUpcaDlg()
{
	
}

void CUpcaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_XNUM, m_bXNum);
	DDX_Check(pDX, IDC_CHECK_ADDON, m_bAddOn);
}


BEGIN_MESSAGE_MAP(CUpcaDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CUpcaDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CUpcaDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
	
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PUPCA_PARAMS pUpca = new UPCA_PARAMS();

	if(IMAGER_GetUPCA(pUpca) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetUPCA()", NULL, MB_TOPMOST);

	m_bEnable	= pUpca->bEnable;
	m_bXCD		= pUpca->bXCD;
	m_bXNum		= pUpca->bXNum;
	m_bAddOn	= pUpca->bAddOn;

	delete pUpca;

	UpdateData(FALSE);

	return TRUE;  
}

void CUpcaDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PUPCA_PARAMS pUpca = new UPCA_PARAMS();

	pUpca->bEnable	= m_bEnable;
	pUpca->bXCD		= m_bXCD;
	pUpca->bXNum	= m_bXNum;
	pUpca->bAddOn	= m_bAddOn;

	if(IMAGER_SetUPCA(pUpca) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetUPCA()", NULL, MB_TOPMOST);

	delete pUpca;

	OnOK();
}
