// TestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "TestDlg.h"
#include "ImagerTestDlg.h"


// CTestDlg dialog

IMPLEMENT_DYNAMIC(CTestDlg, CDialog)

CTestDlg::CTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestDlg::IDD, pParent)
	, m_strStaticType(_T(""))
	, m_strEditData(_T(""))
{
	m_fontType = NULL;
	m_fontData = NULL;
}

CTestDlg::~CTestDlg()
{
	ReleaseCtrlFont();
}

void CTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_STATIC_TYPE, m_strStaticType);
	DDX_Text(pDX, IDC_EDIT_DATA, m_strEditData);
}


BEGIN_MESSAGE_MAP(CTestDlg, CDialog)
	ON_MESSAGE(WM_SCAN_DATA, OnScanRead)
	ON_BN_CLICKED(IDC_BTN_SCAN, &CTestDlg::OnBnClickedBtnScan)
	ON_BN_CLICKED(IDC_BTN_SCANCANCEL, &CTestDlg::OnBnClickedBtnScancancel)
END_MESSAGE_MAP()


BOOL CTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	SetCtrlFont();

	m_strStaticType = L"TYPE";
	m_strEditData = L"DATA";

	UpdateData(FALSE);

	return TRUE;  
}

void CTestDlg::OnBnClickedBtnScan()
{
	IMAGER_Read();
}

void CTestDlg::OnBnClickedBtnScancancel()
{
	IMAGER_ReadCancel();
}

LRESULT CTestDlg::OnScanRead(WPARAM wParam, LPARAM lParam)
{
	TCHAR	szBarType[1024] = {0, };
	TCHAR	szBarData[1024] = {0, };

	IMAGER_GetScanData(szBarType, szBarData);

	m_strStaticType = szBarType;
	m_strEditData	= szBarData;	

	UpdateData(FALSE);

	return LRESULT();
}

void CTestDlg::ReleaseCtrlFont()
{
	if ( m_fontType != NULL )
	{
		m_fontType->DeleteObject();
		delete m_fontType;
		m_fontType = NULL;
	}

	if ( m_fontData != NULL )
	{
		m_fontData->DeleteObject();
		delete m_fontData;
		m_fontData = NULL;
	}
}

void CTestDlg::SetCtrlFont()
{
	ReleaseCtrlFont();

	m_fontType = new CFont();
	m_fontData = new CFont();

	CreateCtrlFont( this, GetDlgItem(IDC_STATIC_TYPE), m_fontType, 12, 900 );
	CreateCtrlFont( this, GetDlgItem(IDC_EDIT_DATA), m_fontData, 12, 900 );
}
