// TelepenDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "TelepenDlg.h"
#include "ImagerTestDlg.h"


// CTelepenDlg dialog

IMPLEMENT_DYNAMIC(CTelepenDlg, CDialog)

CTelepenDlg::CTelepenDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTelepenDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bNumeric(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{
	
}

CTelepenDlg::~CTelepenDlg()
{
	
}

void CTelepenDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_NUMERIC, m_bNumeric);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
}


BEGIN_MESSAGE_MAP(CTelepenDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CTelepenDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CTelepenDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
	
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PTELEPEN_PARAMS pTelepen = new TELEPEN_PARAMS();

	if(IMAGER_GetTELEPEN(pTelepen) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetTELEPEN()", NULL, MB_TOPMOST);

	m_bEnable	= pTelepen->bEnable;
	m_bNumeric	= pTelepen->bNumeric;
	m_nMinLen	= pTelepen->nMinLen;
	m_nMaxLen	= pTelepen->nMaxLen;

	delete pTelepen;

	UpdateData(FALSE);

	return TRUE;  
}


void CTelepenDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PTELEPEN_PARAMS pTelepen = new TELEPEN_PARAMS();

	pTelepen->bEnable		= m_bEnable;
	pTelepen->bNumeric		= m_bNumeric;
	pTelepen->nMinLen		= m_nMinLen;
	pTelepen->nMaxLen		= m_nMaxLen;

	if(IMAGER_SetTELEPEN(pTelepen) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetTELEPEN()", NULL, MB_TOPMOST);

	delete pTelepen;

	OnOK();
}
