#pragma once
#include "afxcmn.h"
#include "afxwin.h"
#include "ImagerTestDlg.h"

typedef enum{
	SYM_AZTEC = 0,
	SYM_CODABAR,
	SYM_CODE11,
	SYM_CODE128,
	SYM_CODE39,
	SYM_CODE49,
	SYM_CODE93,
	SYM_COMPOSITE,
	SYM_DATAMATRIX,
	SYM_EAN8,
	SYM_EAN13,
	SYM_INT25,
	SYM_MAXICODE,
	SYM_MICROPDF,
	SYM_OCR,
	SYM_PDF417,
	SYM_POSTNET,
	SYM_QR,
	SYM_RSS,
	SYM_UPCA,
	SYM_UPCE,
	SYM_ISBT,
	SYM_BPO,
	SYM_CANPOST,
	SYM_AUSPOST,
	SYM_IATA25,
	SYM_CODABLOCK,
	SYM_JAPOST,
	SYM_PLANET,
	SYM_DUTCHPOST,
	SYM_MSI,
	SYM_TLCODE39,
	SYM_STRT25,
	SYM_MATRIX25,
	SYM_PLESSEY,
	SYM_CHINAPOST,
	SYM_KOREAPOST,
	SYM_TELEPEN,
	SYM_CODE16K,
	SYM_POSICODE,
	SYM_COUPONCODE,
	SYM_USBS4CB,
	SYM_IDTAG,
	SYM_LABEL,
	SYM_GS1_128,
	SYM_HANXIN,
	SYM_GRIDMATRIX
}SYMBOLOGY_LIST;

// CSymbologyDlg dialog

class CSymbologyDlg : public CDialog
{
	DECLARE_DYNAMIC(CSymbologyDlg)

public:
	CSymbologyDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CSymbologyDlg();

// Dialog Data
	enum { IDD = IDD_SYMBOLOGY_DLG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:

	PAZTEC_PARAMS		pAztec;
	PCODABAR_PARAMS		pCodabar;
	PCODE11_PARAMS		pCode11;
	PCODE128_PARAMS		pCode128;
	PCODE39_PARAMS		pCode39;
	PCODE49_PARAMS		pCode49;
	PCODE93_PARAMS		pCode93;
	PCOMPOSITE_PARAMS	pComposite;
	PDATAMATRIX_PARAMS	pDatamatrix;
	PINT25_PARAMS		pInt25;
	PMAXICODE_PARAMS	pMaxicode;
	PMICROPDF_PARAMS	pMicropdf;
	PPDF417_PARAMS		pPdf417;
	PQR_PARAMS			pQr;
	PRSS_PARAMS			pRss;
	PIATA25_PARAMS		pIata25;
	PCODABLOCK_PARAMS	pCodablock;
	PMSI_PARAMS			pMsi;
	PSTRT25_PARAMS		pStrt25;
	PMATRIX25_PARAMS	pMatrix25;
	PPLESSEY_PARAMS		pPlessey;
	PCHINAPOST_PARAMS	pChinapost;
	PKOREAPOST_PARAMS	pKoreapost;
	PTELEPEN_PARAMS		pTelepen;
	PCODE16K_PARAMS		pCode16k;
	PPOSICODE_PARAMS	pPosicode;

	CListCtrl	m_ctrlListSymbology;	
	CStatic		m_ctrlStaticMin;
	CStatic		m_ctrlStaticMax;
	CEdit		m_ctrlEditMin;
	CEdit		m_ctrlEditMax;
	CButton		m_ctrlBtnParam;
	CButton		m_ctrlBtnApply;	
	int			m_nMinLen;
	int			m_nMaxLen;
	
	virtual BOOL OnInitDialog();
	afx_msg void OnBnClickedButton1();
	afx_msg void OnBnClickedBtnAll();
	afx_msg void OnBnClickedBtnDefault();
	afx_msg void OnHdnItemclickListSymbology(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedOk();
	afx_msg void OnNMClickListSymbology(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedBtnParam();
	afx_msg void OnBnClickedBtnApply();
	void SetSymbologyList(void);
	afx_msg void OnNMCustomdrawListSymbology(NMHDR *pNMHDR, LRESULT *pResult);
};
