// SymbologyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "SymbologyDlg.h"
#include "ImagerTestDlg.h"

#include "CodabarDlg.h"
#include "Code11Dlg.h"
#include "Code39Dlg.h"
#include "CompositeDlg.h"
#include "Ean13Dlg.h"
#include "Ean8Dlg.h"
#include "Int25Dlg.h"
#include "MSIDlg.h"
#include "PlanetDlg.h"
#include "PosicodeDlg.h"
#include "PostnetDlg.h"
#include "RssDlg.h"
#include "TelepenDlg.h"
#include "UpcaDlg.h"
#include "UpceDlg.h"
#include "OcrDlg.h"



// CSymbologyDlg dialog

TCHAR BARCODE_TYPE[][47] = {
	L"AZTEC", L"CODABAR", L"CODE11", L"CODE128", L"CODE39", L"CODE49", L"CODE93",
	L"COMPOSITE", L"DATAMATRIX", L"EAN-8", L"EAN-13", L"INT25", L"MAXICODE", L"MICROPDF",	
	L"OCR", L"PDF417", L"POSTNET", L"QR", L"RSS", L"UPC-A", L"UPC-E",
	L"ISBT", L"BPO", L"CANPOST", L"AUSPOST", L"IATA25", L"CODABLOCK", L"JAPOST",	
	L"PLANET", L"DUTCHPOST", L"MSI", L"TLCODE39", L"STRT25",
	L"MATRIX25", L"PLESSEY", L"CHINAPOST", L"KOREAPOST", L"TELEPEN", L"CODE16K", L"POSICODE",
	L"COUPONCODE", L"USPS4CB", L"IDTAG", L"LABEL", L"GS1-128", L"HANXIN", L"GRIDMATRIX"
};

BOOL BARCODE_ENABLED[47] = {
	TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE,
	TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE,	
	FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE,
	TRUE, TRUE, FALSE, TRUE, TRUE, FALSE, FALSE,	
	TRUE, TRUE, TRUE, TRUE, FALSE,
	TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE,
	TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE
};

#define OFF_LIST_CHECK 0x1000

IMPLEMENT_DYNAMIC(CSymbologyDlg, CDialog)

CSymbologyDlg::CSymbologyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSymbologyDlg::IDD, pParent)

	, m_nMinLen(0)
	, m_nMaxLen(0)
{
	pAztec		= new AZTEC_PARAMS();
	pCodabar	= new CODABAR_PARAMS();
	pCode11		= new CODE11_PARAMS();
	pCode128	= new CODE128_PARAMS();
	pCode39		= new CODE39_PARAMS();
	pCode49		= new CODE49_PARAMS();
	pCode93		= new CODE93_PARAMS();
	pComposite	= new COMPOSITE_PARAMS();
	pDatamatrix = new DATAMATRIX_PARAMS();
	pInt25		= new INT25_PARAMS();
	pMaxicode	= new MAXICODE_PARAMS();
	pMicropdf	= new MICROPDF_PARAMS();
	pPdf417		= new PDF417_PARAMS();
	pQr			= new QR_PARAMS();
	pRss		= new RSS_PARAMS();
	pIata25		= new IATA25_PARAMS();
	pCodablock	= new CODABLOCK_PARAMS();
	pMsi		= new MSI_PARAMS();
	pStrt25		= new STRT25_PARAMS();
	pMatrix25	= new MATRIX25_PARAMS();
	pPlessey	= new PLESSEY_PARAMS();
	pChinapost	= new CHINAPOST_PARAMS();
	pKoreapost	= new KOREAPOST_PARAMS();
	pTelepen	= new TELEPEN_PARAMS();
	pCode16k	= new CODE16K_PARAMS();
	pPosicode	= new POSICODE_PARAMS();

}

CSymbologyDlg::~CSymbologyDlg()
{
	delete pAztec;
	delete pCodabar;
	delete pCode11;
	delete pCode128;
	delete pCode39;
	delete pCode49;
	delete pCode93;
	delete pComposite;
	delete pDatamatrix;
	delete pInt25;
	delete pMaxicode;
	delete pMicropdf;
	delete pQr;
	delete pRss;
	delete pIata25;
	delete pCodablock;
	delete pMsi;
	delete pStrt25;
	delete pMatrix25;
	delete pPlessey;
	delete pChinapost;
	delete pKoreapost;
	delete pTelepen;
	delete pCode16k;
	delete pPosicode;
}

void CSymbologyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_SYMBOLOGY, m_ctrlListSymbology);
	DDX_Control(pDX, IDC_STATIC_MIN, m_ctrlStaticMin);
	DDX_Control(pDX, IDC_STATIC_MAX, m_ctrlStaticMax);
	DDX_Control(pDX, IDC_EDIT_MIN, m_ctrlEditMin);
	DDX_Control(pDX, IDC_EDIT_MAX, m_ctrlEditMax);
	DDX_Control(pDX, IDC_BTN_PARAM, m_ctrlBtnParam);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
	DDX_Control(pDX, IDC_BTN_APPLY, m_ctrlBtnApply);
}


BEGIN_MESSAGE_MAP(CSymbologyDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_ALL, &CSymbologyDlg::OnBnClickedBtnAll)
	ON_BN_CLICKED(IDC_BTN_DEFAULT, &CSymbologyDlg::OnBnClickedBtnDefault)
	ON_NOTIFY(NM_CLICK, IDC_LIST_SYMBOLOGY, &CSymbologyDlg::OnNMClickListSymbology)
	ON_BN_CLICKED(IDC_BTN_PARAM, &CSymbologyDlg::OnBnClickedBtnParam)
	ON_BN_CLICKED(IDC_BTN_APPLY, &CSymbologyDlg::OnBnClickedBtnApply)
	ON_BN_CLICKED(IDOK, &CSymbologyDlg::OnBnClickedOk)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_LIST_SYMBOLOGY, &CSymbologyDlg::OnNMCustomdrawListSymbology)
END_MESSAGE_MAP()


BOOL CSymbologyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	ListView_SetExtendedListViewStyle(m_ctrlListSymbology.GetSafeHwnd(),LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT);

	m_ctrlListSymbology.InsertColumn(0,L"ENABLE",LVCFMT_LEFT,65);
	m_ctrlListSymbology.InsertColumn(1,L"SYMBOLOGY",LVCFMT_LEFT,143);		

	int	i = 0;
	for(i = 46; i>=0; i--)
	{
		m_ctrlListSymbology.CheckAutoCenter();
		m_ctrlListSymbology.InsertItem(0, NULL, 0);
		m_ctrlListSymbology.SetItemText(0, 1, BARCODE_TYPE[i]);		
	}

	SetSymbologyList();	

	return TRUE; 
}



void CSymbologyDlg::SetSymbologyList(void)
{
	PDECODER pSym = new DECODER();

	BOOL	bEnable[47] = {0, };
	int		i			= 0;

	if(IMAGER_GetSymbology(pSym) == FALSE)
		::MessageBox(NULL, L"ERROR : IMAGER_GetSymbology()", NULL, MB_TOPMOST);

	bEnable[0]	 = pSym->bAZTEC;
	bEnable[1]	 = pSym->bCODABAR;
	bEnable[2]	 = pSym->bCODE11;
	bEnable[3]	 = pSym->bCODE128;
	bEnable[4]	 = pSym->bCODE39;
	bEnable[5]	 = pSym->bCODE49;
	bEnable[6]	 = pSym->bCODE93;
	bEnable[7]	 = pSym->bCOMPOSITE;
	bEnable[8]	 = pSym->bDATAMATRIX;
	bEnable[9]	 = pSym->bEAN8;
	bEnable[10]  = pSym->bEAN13;
	bEnable[11]  = pSym->bINT25;
	bEnable[12]  = pSym->bMAXICODE;
	bEnable[13]  = pSym->bMICROPDF;
	bEnable[14]  = pSym->bOCR;
	bEnable[15]  = pSym->bPDF417;
	bEnable[16]  = pSym->bPOSTNET;
	bEnable[17]  = pSym->bQR;
	bEnable[18]  = pSym->bRSS;
	bEnable[19]  = pSym->bUPCA;
	bEnable[20]  = pSym->bUPCE;	
	bEnable[21]  = pSym->bISBT;
	bEnable[22]  = pSym->bBPO;
	bEnable[23]  = pSym->bCANPOST;
	bEnable[24]  = pSym->bAUSPOST;
	bEnable[25]  = pSym->bIATA25;
	bEnable[26]  = pSym->bCODABLOCK;
	bEnable[27]  = pSym->bJAPOST;
	bEnable[28]  = pSym->bPLANET;
	bEnable[29]  = pSym->bDUTCHPOST;
	bEnable[30]  = pSym->bMSI;
	bEnable[31]  = pSym->bTLCODE39;
	bEnable[32]  = pSym->bSTRT25;
	bEnable[33]  = pSym->bMATRIX25;
	bEnable[34]  = pSym->bPLESSEY;
	bEnable[35]  = pSym->bCHINAPOST;
	bEnable[36]  = pSym->bKOREAPOST;
	bEnable[37]  = pSym->bTELEPEN;
	bEnable[38]  = pSym->bCODE16K;
	bEnable[39]  = pSym->bPOSICODE;
	bEnable[40]  = pSym->bCOUPONCODE;
	bEnable[41]  = pSym->bUSPS4CB;
	bEnable[42]  = pSym->bIDTAG;
	bEnable[43]  = pSym->bLABEL;
	bEnable[44]  = pSym->bGS1_128;
	bEnable[45]  = pSym->bHANXIN;
	bEnable[46]  = pSym->bGRIDMATRIX;

	for(i=0; i<47; i++)
	{
		m_ctrlListSymbology.SetCheck(i, bEnable[i]);	
	}

	delete pSym;

}

void CSymbologyDlg::OnBnClickedBtnAll()
{
	IMAGER_SetSymbologyAll();

	SetSymbologyList();

	GetDlgItem(IDC_LIST_SYMBOLOGY)->Invalidate();
}

void CSymbologyDlg::OnBnClickedBtnDefault()
{
 	IMAGER_SetSymbologyDefault();
 
 	SetSymbologyList();
 
 	GetDlgItem(IDC_LIST_SYMBOLOGY)->Invalidate();
}

void CSymbologyDlg::OnNMClickListSymbology(NMHDR *pNMHDR, LRESULT *pResult)
{
	NM_LISTVIEW* pNMLV =  (NM_LISTVIEW*)pNMHDR;
	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	if ( pImagerTestDlg->m_DeviceType == DEVICE_M3BLACK && !BARCODE_ENABLED[pNMLV->iItem] )
	{
		pNMLV->iItem = -1;
		ListView_SetSelectionMark( m_ctrlListSymbology.GetSafeHwnd(), -1);
/*
		m_ctrlStaticMin.EnableWindow(FALSE);
		m_ctrlStaticMax.EnableWindow(FALSE);
		m_ctrlEditMin.EnableWindow(FALSE);
		m_ctrlEditMax.EnableWindow(FALSE);
		m_ctrlBtnApply.EnableWindow(FALSE);
		m_ctrlBtnParam.EnableWindow(FALSE);
*/		
	}

	switch(pNMLV->iItem)
	{
		case SYM_AZTEC:
		case SYM_CODE128:
		case SYM_CODE49:
		case SYM_CODE93:
		case SYM_DATAMATRIX:
		case SYM_MAXICODE:
		case SYM_MICROPDF:
		case SYM_PDF417:		
		case SYM_QR:
		case SYM_IATA25:
		case SYM_CODABLOCK:
		case SYM_STRT25:
		case SYM_MATRIX25:
		case SYM_PLESSEY:
		case SYM_CHINAPOST:
		case SYM_KOREAPOST:
		case SYM_CODE16K:
			m_ctrlStaticMin.EnableWindow(TRUE);
			m_ctrlStaticMax.EnableWindow(TRUE);
			m_ctrlEditMin.EnableWindow(TRUE);
			m_ctrlEditMax.EnableWindow(TRUE);
			m_ctrlBtnApply.EnableWindow(TRUE);
			m_ctrlBtnParam.EnableWindow(FALSE);
			break;

		case SYM_CODABAR:
		case SYM_CODE11:
		case SYM_CODE39:
		case SYM_COMPOSITE:
		case SYM_INT25:
		case SYM_RSS:
		case SYM_MSI:
		case SYM_TELEPEN:
		case SYM_POSICODE:
			m_ctrlStaticMin.EnableWindow(TRUE);
			m_ctrlStaticMax.EnableWindow(TRUE);
			m_ctrlEditMin.EnableWindow(TRUE);
			m_ctrlEditMax.EnableWindow(TRUE);
			m_ctrlBtnApply.EnableWindow(TRUE);
			m_ctrlBtnParam.EnableWindow(TRUE);
			break;
		
		case SYM_EAN8:
		case SYM_EAN13:
		case SYM_POSTNET:
		case SYM_UPCA:
		case SYM_UPCE:
		case SYM_PLANET:
		case SYM_OCR:
			m_ctrlStaticMin.EnableWindow(FALSE);
			m_ctrlStaticMax.EnableWindow(FALSE);
			m_ctrlEditMin.EnableWindow(FALSE);
			m_ctrlEditMax.EnableWindow(FALSE);
			m_ctrlBtnApply.EnableWindow(FALSE);
			m_ctrlBtnParam.EnableWindow(TRUE);
			break;

		case SYM_ISBT:
		case SYM_BPO:
		case SYM_CANPOST:
		case SYM_AUSPOST:
		case SYM_JAPOST:
		case SYM_DUTCHPOST:
		case SYM_TLCODE39:
		case SYM_COUPONCODE:
		case SYM_USBS4CB:
		case SYM_IDTAG:
		case SYM_LABEL:
		case SYM_GS1_128:
		case SYM_HANXIN:
		case SYM_GRIDMATRIX:
			m_ctrlStaticMin.EnableWindow(FALSE);
			m_ctrlStaticMax.EnableWindow(FALSE);
			m_ctrlEditMin.EnableWindow(FALSE);
			m_ctrlEditMax.EnableWindow(FALSE);
			m_ctrlBtnApply.EnableWindow(FALSE);
			m_ctrlBtnParam.EnableWindow(FALSE);
			break;			
	}

	switch(pNMLV->iItem)
	{
		case SYM_AZTEC:
			if(IMAGER_GetAZTEC(pAztec) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetAZTEC()", NULL, MB_TOPMOST);

			m_nMinLen = pAztec->nMinLen;
			m_nMaxLen = pAztec->nMaxLen;
			break;

		case SYM_CODABAR:
			if(IMAGER_GetCODABAR(pCodabar) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetCODABAR()", NULL, MB_TOPMOST);

			m_nMinLen = pCodabar->nMinLen;
			m_nMaxLen = pCodabar->nMaxLen;
			break;

		case SYM_CODE11:
			if(IMAGER_GetCODE11(pCode11) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetCODE11()", NULL, MB_TOPMOST);

			m_nMinLen = pCode11->nMinLen;
			m_nMaxLen = pCode11->nMaxLen;
			break;

		case SYM_CODE128:
			if(IMAGER_GetCODE128(pCode128) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetCODE128()", NULL, MB_TOPMOST);

			m_nMinLen = pCode128->nMinLen;
			m_nMaxLen = pCode128->nMaxLen;
			break;

		case SYM_CODE39:
			if(IMAGER_GetCODE39(pCode39) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetCODE39()", NULL, MB_TOPMOST);

			m_nMinLen = pCode39->nMinLen;
			m_nMaxLen = pCode39->nMaxLen;
			break;

		case SYM_CODE49:
			if(IMAGER_GetCODE49(pCode49) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetCODE49()", NULL, MB_TOPMOST);

			m_nMinLen = pCode49->nMinLen;
			m_nMaxLen = pCode49->nMaxLen;
			break;

		case SYM_CODE93:
			if(IMAGER_GetCODE93(pCode93) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetCODE93()", NULL, MB_TOPMOST);

			m_nMinLen = pCode93->nMinLen;
			m_nMaxLen = pCode93->nMaxLen;
			break;

		case SYM_COMPOSITE:
			if(IMAGER_GetCOMPOSITE(pComposite) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetCOMPOSITE()", NULL, MB_TOPMOST);

			m_nMinLen = pComposite->nMinLen;
			m_nMaxLen = pComposite->nMaxLen;
			break;

		case SYM_DATAMATRIX:
			if(IMAGER_GetDATAMATRIX(pDatamatrix) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetDATAMATRIX()", NULL, MB_TOPMOST);

			m_nMinLen = pDatamatrix->nMinLen;
			m_nMaxLen = pDatamatrix->nMaxLen;
			break;

		
		case SYM_INT25:
			if(IMAGER_GetINT25(pInt25) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetINT25()", NULL, MB_TOPMOST);

			m_nMinLen = pInt25->nMinLen;
			m_nMaxLen = pInt25->nMaxLen;
			break;

		case SYM_MAXICODE:
			if(IMAGER_GetMAXICODE(pMaxicode) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetMAXICODE()", NULL, MB_TOPMOST);

			m_nMinLen = pMaxicode->nMinLen;
			m_nMaxLen = pMaxicode->nMaxLen;
			break;

		case SYM_MICROPDF:
			if(IMAGER_GetMICROPDF(pMicropdf) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetMICROPDF()", NULL, MB_TOPMOST);

			m_nMinLen = pMicropdf->nMinLen;
			m_nMaxLen = pMicropdf->nMaxLen;
			break;

		case SYM_PDF417:
			if(IMAGER_GetPDF417(pPdf417) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetPDF417()", NULL, MB_TOPMOST);

			m_nMinLen = pPdf417->nMinLen;
			m_nMaxLen = pPdf417->nMaxLen;
			break;

		
		case SYM_QR:
			if(IMAGER_GetQR(pQr) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetQR()", NULL, MB_TOPMOST);

			m_nMinLen = pQr->nMinLen;
			m_nMaxLen = pQr->nMaxLen;
			break;

		case SYM_RSS:
			if(IMAGER_GetRSS(pRss) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetRSS()", NULL, MB_TOPMOST);

			m_nMinLen = pRss->nMinLen;
			m_nMaxLen = pRss->nMaxLen;
			break;

		
		case SYM_IATA25:
			if(IMAGER_GetIATA25(pIata25) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetIATA25()", NULL, MB_TOPMOST);

			m_nMinLen = pIata25->nMinLen;
			m_nMaxLen = pIata25->nMaxLen;
			break;

		case SYM_CODABLOCK:
			if(IMAGER_GetCODABLOCK(pCodablock) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetCODABLOCK()", NULL, MB_TOPMOST);

			m_nMinLen = pCodablock->nMinLen;
			m_nMaxLen = pCodablock->nMaxLen;
			break;

		
		case SYM_MSI:
			if(IMAGER_GetMSI(pMsi) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetMSI()", NULL, MB_TOPMOST);

			m_nMinLen = pMsi->nMinLen;
			m_nMaxLen = pMsi->nMaxLen;
			break;

		case SYM_STRT25:
			if(IMAGER_GetSTRT25(pStrt25) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetSTRT25()", NULL, MB_TOPMOST);

			m_nMinLen = pStrt25->nMinLen;
			m_nMaxLen = pStrt25->nMaxLen;
			break;

		case SYM_MATRIX25:
			if(IMAGER_GetMATRIX25(pMatrix25) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetMATRIX25()", NULL, MB_TOPMOST);

			m_nMinLen = pMatrix25->nMinLen;
			m_nMaxLen = pMatrix25->nMaxLen;
			break;

		case SYM_PLESSEY:
			if(IMAGER_GetPLESSEY(pPlessey) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetPLESSEY()", NULL, MB_TOPMOST);

			m_nMinLen = pPlessey->nMinLen;
			m_nMaxLen = pPlessey->nMaxLen;
			break;

		case SYM_CHINAPOST:
			if(IMAGER_GetCHINAPOST(pChinapost) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetCHINAPOST()", NULL, MB_TOPMOST);

			m_nMinLen = pChinapost->nMinLen;
			m_nMaxLen = pChinapost->nMaxLen;
			break;

		case SYM_KOREAPOST:
			if(IMAGER_GetKOREAPOST(pKoreapost) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetKOREAPOST()", NULL, MB_TOPMOST);

			m_nMinLen = pKoreapost->nMinLen;
			m_nMaxLen = pKoreapost->nMaxLen;
			break;

		case SYM_TELEPEN:
			if(IMAGER_GetTELEPEN(pTelepen) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetTELEPEN()", NULL, MB_TOPMOST);

			m_nMinLen = pTelepen->nMinLen;
			m_nMaxLen = pTelepen->nMaxLen;
			break;

		case SYM_CODE16K:
			if(IMAGER_GetCODE16K(pCode16k) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetCODE16K()", NULL, MB_TOPMOST);

			m_nMinLen = pCode16k->nMinLen;
			m_nMaxLen = pCode16k->nMaxLen;
			break;

		case SYM_POSICODE:
			if(IMAGER_GetPOSICODE(pPosicode) == FALSE)
				::MessageBox(NULL, L"Error : IMAGER_GetPOSICODE()", NULL, MB_TOPMOST);

			m_nMinLen = pPosicode->nMinLen;
			m_nMaxLen = pPosicode->nMaxLen;
			break;

		case SYM_OCR:
		case SYM_EAN8:			
		case SYM_EAN13:
		case SYM_POSTNET:
		case SYM_UPCA:
		case SYM_UPCE:
		case SYM_PLANET:			
		case SYM_ISBT:
		case SYM_BPO:
		case SYM_CANPOST:
		case SYM_AUSPOST:
		case SYM_JAPOST:
		case SYM_DUTCHPOST:
		case SYM_TLCODE39:
		case SYM_COUPONCODE:
		case SYM_USBS4CB:
		case SYM_IDTAG:
		case SYM_LABEL:
		case SYM_GS1_128:
		case SYM_HANXIN:
		case SYM_GRIDMATRIX:
			m_nMinLen = -1;
			m_nMaxLen = -1;
			break;			
	}

	if ( m_nMinLen == -1 && m_nMaxLen == -1 )
	{
		m_ctrlStaticMin.EnableWindow(FALSE);
		m_ctrlStaticMax.EnableWindow(FALSE);
		m_ctrlEditMin.EnableWindow(FALSE);
		m_ctrlEditMax.EnableWindow(FALSE);
	}

	UpdateData(FALSE);

	if(pNMLV->iItem != -1)
	{
		if(m_ctrlListSymbology.GetCheck(pNMLV->iItem))
			m_ctrlListSymbology.SetCheck(pNMLV->iItem, FALSE);
		else
			m_ctrlListSymbology.SetCheck(pNMLV->iItem, TRUE);
	}
	else
	{
		m_ctrlStaticMin.EnableWindow(FALSE);
		m_ctrlStaticMax.EnableWindow(FALSE);
		m_ctrlEditMin.EnableWindow(FALSE);
		m_ctrlEditMax.EnableWindow(FALSE);
		m_ctrlBtnApply.EnableWindow(FALSE);
		m_ctrlBtnParam.EnableWindow(FALSE);

	}

	*pResult = 0;
}

void CSymbologyDlg::OnBnClickedBtnParam()
{
	CCodabarDlg		CodabarDlg;
	CCode11Dlg		Code11Dlg;
	CCode39Dlg		Code39Dlg;
	CCompositeDlg	CompositeDlg;
	CEan13Dlg		Ean13Dlg;
	CEan8Dlg		Ean8Dlg;
	CInt25Dlg		Int25Dlg;
	CMsiDlg			MsiDlg;
	CPlanetDlg		PlanetDlg;
	CPostnetDlg		PostnetDlg;
	CRssDlg			RssDlg;
	CTelepenDlg		TelepenDlg;
	CUpcaDlg		UpcaDlg;
	CUpceDlg		UpceDlg;
	COcrDlg			OcrDlg;
	CPosicodeDlg	PosicodeDlg;

	int nMark = m_ctrlListSymbology.GetSelectionMark();

	switch(nMark)
	{
	case SYM_CODABAR:	
		CodabarDlg.DoModal();
		SetSymbologyList();			
		break;

	case SYM_CODE11:
		Code11Dlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_CODE39:
		Code39Dlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_COMPOSITE:
		CompositeDlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_EAN13:
		Ean13Dlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_EAN8:
		Ean8Dlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_INT25:
		Int25Dlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_OCR:
		OcrDlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_MSI:
		MsiDlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_PLANET:
		PlanetDlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_POSTNET:
		PostnetDlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_RSS:
		RssDlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_TELEPEN:
		TelepenDlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_UPCA:
		UpcaDlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_UPCE:
		UpceDlg.DoModal();
		SetSymbologyList();
		break;

	case SYM_POSICODE:
		PosicodeDlg.DoModal();
		SetSymbologyList();
		break;
	}
}


void CSymbologyDlg::OnBnClickedBtnApply()
{
	UpdateData(TRUE);

	int nMark = m_ctrlListSymbology.GetSelectionMark();

	switch(nMark)
	{
	case SYM_AZTEC:
		pAztec->nMinLen = m_nMinLen;
		pAztec->nMaxLen = m_nMaxLen;

		if(IMAGER_SetAZTEC(pAztec) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_GetCODABAR()", NULL, MB_TOPMOST);

		break;

	case SYM_CODABAR:		
		pCodabar->nMinLen = m_nMinLen;
		pCodabar->nMaxLen = m_nMaxLen;

		if(IMAGER_SetCODABAR(pCodabar) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_GetCODABAR()", NULL, MB_TOPMOST);

		break;

	case SYM_CODE11:
		pCodabar->nMinLen = m_nMinLen;
		pCodabar->nMaxLen = m_nMaxLen;

		if(IMAGER_SetCODE11(pCode11) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_GetCODE11()", NULL, MB_TOPMOST);

		break;

	case SYM_CODE128:
		pCodabar->nMinLen = m_nMinLen;
		pCodabar->nMaxLen = m_nMaxLen;

		if(IMAGER_SetCODE128(pCode128) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_GetCODE128()", NULL, MB_TOPMOST);

		break;

	case SYM_CODE39:
		pCodabar->nMinLen = m_nMinLen;
		pCodabar->nMaxLen = m_nMaxLen;

		if(IMAGER_SetCODE39(pCode39) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_GetCODE39()", NULL, MB_TOPMOST);

		break;

	case SYM_CODE49:
		pCodabar->nMinLen = m_nMinLen;
		pCodabar->nMaxLen = m_nMaxLen;

		if(IMAGER_SetCODE49(pCode49) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_GetCODE49()", NULL, MB_TOPMOST);

		break;

	case SYM_CODE93:
		pCodabar->nMinLen = m_nMinLen;
		pCodabar->nMaxLen = m_nMaxLen;

		if(IMAGER_SetCODE93(pCode93) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_GetCODE93()", NULL, MB_TOPMOST);

		break;

	case SYM_COMPOSITE:
		pCodabar->nMinLen = m_nMinLen;
		pCodabar->nMaxLen = m_nMaxLen;

		if(IMAGER_SetCOMPOSITE(pComposite) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_GetCOMPOSITE()", NULL, MB_TOPMOST);

		break;

	case SYM_DATAMATRIX:
		pCodabar->nMinLen = m_nMinLen;
		pCodabar->nMaxLen = m_nMaxLen;

		if(IMAGER_SetDATAMATRIX(pDatamatrix) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_GetDATAMATRIX()", NULL, MB_TOPMOST);

		break;

	case SYM_INT25:
		pCodabar->nMinLen = m_nMinLen;
		pCodabar->nMaxLen = m_nMaxLen;

		if(IMAGER_SetINT25(pInt25) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetINT25()", NULL, MB_TOPMOST);

 		break;

	case SYM_MAXICODE:
		pMaxicode->nMinLen = m_nMinLen;
		pMaxicode->nMaxLen = m_nMaxLen;

		if(IMAGER_SetMAXICODE(pMaxicode) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetMAXICODE()", NULL, MB_TOPMOST);

		break;

	case SYM_MICROPDF:
		pMicropdf->nMinLen = m_nMinLen;
		pMicropdf->nMaxLen = m_nMaxLen;

		if(IMAGER_SetMICROPDF(pMicropdf) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetMICROPDF()", NULL, MB_TOPMOST);

		break;

	case SYM_PDF417:
		pPdf417->nMinLen = m_nMinLen;
		pPdf417->nMaxLen = m_nMaxLen;

		if(IMAGER_SetPDF417(pPdf417) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetPDF417()", NULL, MB_TOPMOST);

		break;

	case SYM_QR:
		pQr->nMinLen = m_nMinLen;
		pQr->nMaxLen = m_nMaxLen;

		if(IMAGER_SetQR(pQr) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetQR()", NULL, MB_TOPMOST);

		break;

	case SYM_RSS:
		pRss->nMinLen = m_nMinLen;
		pRss->nMaxLen = m_nMaxLen;

		if(IMAGER_SetRSS(pRss) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetRSS()", NULL, MB_TOPMOST);

		break;

	case SYM_IATA25:
		pIata25->nMinLen = m_nMinLen;
		pIata25->nMaxLen = m_nMaxLen;

		if(IMAGER_SetIATA25(pIata25) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetIATA25()", NULL, MB_TOPMOST);

		break;

	case SYM_CODABLOCK:
		pCodablock->nMinLen = m_nMinLen;
		pCodablock->nMaxLen = m_nMaxLen;

		if(IMAGER_SetCODABLOCK(pCodablock) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetCODABLOCK()", NULL, MB_TOPMOST);

		break;

	case SYM_MSI:
		pMsi->nMinLen = m_nMinLen;
		pMsi->nMaxLen = m_nMaxLen;

		if(IMAGER_SetMSI(pMsi) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetMSI()", NULL, MB_TOPMOST);

		break;

	case SYM_STRT25:
		pStrt25->nMinLen = m_nMinLen;
		pStrt25->nMaxLen = m_nMaxLen;

		if(IMAGER_SetSTRT25(pStrt25) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetSTRT25()", NULL, MB_TOPMOST);

		break;

	case SYM_MATRIX25:
		pMatrix25->nMinLen = m_nMinLen;
		pMatrix25->nMaxLen = m_nMaxLen;

		if(IMAGER_SetMATRIX25(pMatrix25) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetMATRIX25()", NULL, MB_TOPMOST);

		break;

	case SYM_PLESSEY:
		pPlessey->nMinLen = m_nMinLen;
		pPlessey->nMaxLen = m_nMaxLen;

		if(IMAGER_SetPLESSEY(pPlessey) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetPLESSEY()", NULL, MB_TOPMOST);

		break;

	case SYM_CHINAPOST:
		pChinapost->nMinLen = m_nMinLen;
		pChinapost->nMaxLen = m_nMaxLen;

		if(IMAGER_SetCHINAPOST(pChinapost) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetCHINAPOST()", NULL, MB_TOPMOST);

		break;

	case SYM_KOREAPOST:
		pKoreapost->nMinLen = m_nMinLen;
		pKoreapost->nMaxLen = m_nMaxLen;

		if(IMAGER_SetKOREAPOST(pKoreapost) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetKOREAPOST()", NULL, MB_TOPMOST);

		break;

	case SYM_TELEPEN:
		pTelepen->nMinLen = m_nMinLen;
		pTelepen->nMaxLen = m_nMaxLen;

		if(IMAGER_SetTELEPEN(pTelepen) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetTELEPEN()", NULL, MB_TOPMOST);

		break;

	case SYM_CODE16K:
		pCode16k->nMinLen = m_nMinLen;
		pCode16k->nMaxLen = m_nMaxLen;

		if(IMAGER_SetCODE16K(pCode16k) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetCODE16K()", NULL, MB_TOPMOST);

		break;

	case SYM_POSICODE:
		pPosicode->nMinLen = m_nMinLen;
		pPosicode->nMaxLen = m_nMaxLen;

		if(IMAGER_SetPOSICODE(pPosicode) == FALSE)
			::MessageBox(NULL, L"Error : IMAGER_SetPOSICODE()", NULL, MB_TOPMOST);

		break;
	}
}

void CSymbologyDlg::OnBnClickedOk()
{
	PDECODER pSym = new DECODER();

	BOOL	bEnable[47] = {0, };
	int		i = 0;

	for(i=0; i<47; i++)
	{
		bEnable[i] = m_ctrlListSymbology.GetCheck(i);		
	}

	pSym->bAZTEC		= bEnable[0];
	pSym->bCODABAR		= bEnable[1];
	pSym->bCODE11		= bEnable[2];
	pSym->bCODE128		= bEnable[3];
	pSym->bCODE39		= bEnable[4];
	pSym->bCODE49		= bEnable[5];
	pSym->bCODE93		= bEnable[6];
	pSym->bCOMPOSITE	= bEnable[7];
	pSym->bDATAMATRIX	= bEnable[8];
	pSym->bEAN8			= bEnable[9];
	pSym->bEAN13		= bEnable[10];
	pSym->bINT25		= bEnable[11];
	pSym->bMAXICODE		= bEnable[12];
	pSym->bMICROPDF		= bEnable[13];
	pSym->bOCR			= bEnable[14];
	pSym->bPDF417		= bEnable[15];
	pSym->bPOSTNET		= bEnable[16];
	pSym->bQR			= bEnable[17];
	pSym->bRSS			= bEnable[18];
	pSym->bUPCA			= bEnable[19];
	pSym->bUPCE			= bEnable[20];
	pSym->bISBT			= bEnable[21];
	pSym->bBPO			= bEnable[22];
	pSym->bCANPOST		= bEnable[23];
	pSym->bAUSPOST		= bEnable[24];
	pSym->bIATA25		= bEnable[25];
	pSym->bCODABLOCK	= bEnable[26];
	pSym->bJAPOST		= bEnable[27];
	pSym->bPLANET		= bEnable[28];
	pSym->bDUTCHPOST	= bEnable[29];
	pSym->bMSI			= bEnable[30];
	pSym->bTLCODE39		= bEnable[31];
	pSym->bSTRT25		= bEnable[32];
	pSym->bMATRIX25		= bEnable[33];
	pSym->bPLESSEY		= bEnable[34];
	pSym->bCHINAPOST	= bEnable[35];
	pSym->bKOREAPOST	= bEnable[36];
	pSym->bTELEPEN		= bEnable[37];
	pSym->bCODE16K		= bEnable[38];
	pSym->bPOSICODE		= bEnable[39];
	pSym->bCOUPONCODE	= bEnable[40];
	pSym->bUSPS4CB		= bEnable[41];
	pSym->bIDTAG		= bEnable[42];
	pSym->bLABEL		= bEnable[43];
	pSym->bGS1_128		= bEnable[44];
	pSym->bHANXIN		= bEnable[45];
	pSym->bGRIDMATRIX	= bEnable[46];

	if(IMAGER_SetSymbology(pSym) == FALSE)
		::MessageBox(NULL, L"ERROR : IMAGER_SetSymbology()", NULL, MB_TOPMOST);

	delete pSym;
	
	OnOK();
}

void CSymbologyDlg::OnNMCustomdrawListSymbology(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVCUSTOMDRAW* pLVCD = reinterpret_cast<NMLVCUSTOMDRAW*>( pNMHDR );
	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	
	 *pResult = CDRF_DODEFAULT;

    // First thing - check the draw stage. If it's the control's prepaint
    // stage, then tell Windows we want messages for every item.

	 if ( CDDS_PREPAINT == pLVCD->nmcd.dwDrawStage )
	 {
		 *pResult = CDRF_NOTIFYITEMDRAW;
	 }
	 else if ( CDDS_ITEMPREPAINT == pLVCD->nmcd.dwDrawStage )
	 {
		 // This is the prepaint stage for an item. Here's where we set the
		 // item's text color. Our return value will tell Windows to draw the
		 // item itself, but it will use the new color we set here.
		 // We'll cycle the colors through red, green, and light blue.

		 if ( pImagerTestDlg->m_DeviceType == DEVICE_M3BLACK && BARCODE_ENABLED[pLVCD->nmcd.dwItemSpec] == FALSE )
			{
				COLORREF crText;

				pLVCD->nmcd.uItemState = CDIS_DISABLED ;
				ListView_SetItemState( m_ctrlListSymbology.GetSafeHwnd(), pLVCD->nmcd.dwItemSpec,           
					OFF_LIST_CHECK, LVIS_STATEIMAGEMASK );
				crText = RGB(128, 128, 128);

				pLVCD->clrText = crText;

				*pResult = CDRF_DODEFAULT;

		 }			

	 }
}
