// ScanOptionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "ScanOptionDlg.h"
#include "ImagerTestDlg.h"
#include "CenteringDlg.h"
#include "DecOptionDlg.h"


// CScanOptionDlg dialog

IMPLEMENT_DYNAMIC(CScanOptionDlg, CDialog)

CScanOptionDlg::CScanOptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CScanOptionDlg::IDD, pParent)
	, m_nSyncMode(0)
	, m_nSound(0)
	, m_bCentering(FALSE)
	, m_bVibrate(FALSE)
	, m_bAimID(FALSE)
	, m_bContinueMode(FALSE)
	, m_bHexMode(FALSE)
{

}

CScanOptionDlg::~CScanOptionDlg()
{
}

void CScanOptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Radio(pDX, IDC_RADIO_ASYNC, m_nSyncMode);
	DDX_Radio(pDX, IDC_RADIO_DEFAULT, m_nSound);
	DDX_Control(pDX, IDC_COMBO_TIMEOUT, m_ctrlComboTimeOut);
	DDX_Check(pDX, IDC_CHECK_CENTERING, m_bCentering);
	DDX_Control(pDX, IDC_BTN_CENTERING, m_ctrlBtnCentering);
	DDX_Check(pDX, IDC_CHECK_VIBRATE, m_bVibrate);
	DDX_Check(pDX, IDC_CHECK_AIMID, m_bAimID);
	DDX_Check(pDX, IDC_CHECK_CONTINUE, m_bContinueMode);
	DDX_Check(pDX, IDC_CHECK_HEX, m_bHexMode);
	DDX_Control(pDX, IDC_COMBO_LIGHTMODE, m_ctrlComboLightMode);
}


BEGIN_MESSAGE_MAP(CScanOptionDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CScanOptionDlg::OnBnClickedOk)
	ON_BN_CLICKED(IDC_CHECK_CENTERING, &CScanOptionDlg::OnBnClickedCheckCentering)
	ON_BN_CLICKED(IDC_BTN_CENTERING, &CScanOptionDlg::OnBnClickedBtnCentering)
	ON_BN_CLICKED(IDC_BTN_DECOPTION, &CScanOptionDlg::OnBnClickedBtnDecoption)
END_MESSAGE_MAP()


BOOL CScanOptionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);	

	m_ctrlComboTimeOut.InsertString(0, L"1");
	m_ctrlComboTimeOut.InsertString(1, L"2");
	m_ctrlComboTimeOut.InsertString(2, L"3");
	m_ctrlComboTimeOut.InsertString(3, L"4");
	m_ctrlComboTimeOut.InsertString(4, L"5");
	m_ctrlComboTimeOut.InsertString(5, L"6");
	m_ctrlComboTimeOut.InsertString(6, L"7");
	m_ctrlComboTimeOut.InsertString(7, L"8");
	m_ctrlComboTimeOut.InsertString(8, L"9");
	m_ctrlComboTimeOut.InsertString(9, L"10");

	m_ctrlComboLightMode.InsertString(0, L"NO LIGHT");
	m_ctrlComboLightMode.InsertString(1, L"AIMER ONLY");
	m_ctrlComboLightMode.InsertString(2, L"LIGHT ONLY");
	m_ctrlComboLightMode.InsertString(3, L"BOTH AIMER & LIGHT");
	
	GetOption();

	if ( pImagerTestDlg->m_DeviceType == DEVICE_M3BLACK )
	{
		GetDlgItem(IDC_CHECK_CENTERING)->EnableWindow(FALSE);
		GetDlgItem(IDC_BTN_DECOPTION)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK_CONTINUE)->EnableWindow(FALSE);

		m_bContinueMode = FALSE;

		GetDlgItem(IDC_BTN_CENTERING)->EnableWindow(FALSE);
		

	}

	return TRUE;  
}

BOOL CScanOptionDlg::GetOption(void)
{
	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	PDECODER_PARAMS pOption = new DECODER_PARAMS();

	if(IMAGER_GetOption(pOption) == FALSE)
	{
		::MessageBox(NULL, L"ERROR : IMAGER_GetOption()", NULL, MB_TOPMOST);
		return FALSE;
	}

	m_nSyncMode		= pImagerTestDlg->m_bSyncMode;
	m_nSound		= pOption->nSound;
	m_bCentering	= pOption->bCentering;
	m_bVibrate		= pOption->bVibrate;
	m_bAimID		= pOption->bXmitAimID;
	m_bContinueMode	= pOption->bContinueMode;
	m_bHexMode		= pOption->bHexMode;

	m_ctrlComboTimeOut.SetCurSel(pOption->nTimeOut - 1);
	m_ctrlComboLightMode.SetCurSel(pOption->nLightMode);

	delete pOption;

	UpdateData(FALSE);

	return TRUE;
}

BOOL CScanOptionDlg::SetOption(void)
{
	UpdateData(TRUE);

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	PDECODER_PARAMS pOption = new DECODER_PARAMS();

	pImagerTestDlg->m_bSyncMode		= m_nSyncMode;
	pOption->nSound					= m_nSound;	
	pOption->bCentering				= m_bCentering;
	pOption->bVibrate				= m_bVibrate;		
	pOption->bXmitAimID				= m_bAimID;	
	pOption->bContinueMode			= m_bContinueMode;
	pImagerTestDlg->m_bContinueMode	= m_bContinueMode;
	pOption->bHexMode				= m_bHexMode;	

	if((m_ctrlComboTimeOut.GetCurSel() > 9) || (m_ctrlComboTimeOut.GetCurSel() < 0))
	{
		::MessageBox(NULL, L"Error : Retry set Timeout", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}

	if((m_ctrlComboLightMode.GetCurSel() > 3) || (m_ctrlComboLightMode.GetCurSel() < 0))
	{
		::MessageBox(NULL, L"Error : Retry set LightMode", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}	

	pOption->nTimeOut	= m_ctrlComboTimeOut.GetCurSel() + 1;
	pOption->nLightMode = m_ctrlComboLightMode.GetCurSel();

	if ( pImagerTestDlg->m_DeviceType == DEVICE_M3BLACK )
	{
		pOption->bContinueMode = FALSE;		

	}

	if(IMAGER_SetOption(pOption) == FALSE)
	{
		::MessageBox(NULL, L"ERROR : IMAGER_SetOption()", NULL, MB_TOPMOST);
		return FALSE;
	}	
	
	delete pOption;

	return TRUE;
}

void CScanOptionDlg::OnBnClickedOk()
{
	if(SetOption() == TRUE)
		OnOK();
}

void CScanOptionDlg::OnBnClickedCheckCentering()
{
	UpdateData(TRUE);

	if(m_bCentering == TRUE)
		m_ctrlBtnCentering.EnableWindow(TRUE);
	else
		m_ctrlBtnCentering.EnableWindow(FALSE);
}

void CScanOptionDlg::OnBnClickedBtnCentering()
{
	CCenteringDlg CenteringDlg;
	CenteringDlg.DoModal();
}

void CScanOptionDlg::OnBnClickedBtnDecoption()
{
	CDecOptionDlg DecOptionDlg;
	DecOptionDlg.DoModal();
}
