// RssDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "RssDlg.h"
#include "ImagerTestDlg.h"


// CRssDlg dialog

IMPLEMENT_DYNAMIC(CRssDlg, CDialog)

CRssDlg::CRssDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRssDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bRssLim(FALSE)
	, m_bRssExp(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{
	
}

CRssDlg::~CRssDlg()
{
	
}

void CRssDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_RSSLIM, m_bRssLim);
	DDX_Check(pDX, IDC_CHECK_RSSEXP, m_bRssExp);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
}


BEGIN_MESSAGE_MAP(CRssDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CRssDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CRssDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
	
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PRSS_PARAMS pRss = new RSS_PARAMS();

	if(IMAGER_GetRSS(pRss) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetRSS()", NULL, MB_TOPMOST);

	m_bEnable = pRss->bEnable;
	m_bRssLim = pRss->bRssLim;
	m_bRssExp = pRss->bRssExp;
	m_nMinLen = pRss->nMinLen;
	m_nMaxLen = pRss->nMaxLen;

	delete pRss;

	UpdateData(FALSE);

	return TRUE;  
}

void CRssDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PRSS_PARAMS pRss = new RSS_PARAMS();

	pRss->bEnable		= m_bEnable;
	pRss->bRssLim		= m_bRssLim;
	pRss->bRssExp		= m_bRssExp;
	pRss->nMinLen		= m_nMinLen;
	pRss->nMaxLen		= m_nMaxLen;

	if(IMAGER_SetRSS(pRss) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetRSS()", NULL, MB_TOPMOST);

	delete pRss;

	OnOK();
}
