// PosicodeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "PosicodeDlg.h"
#include "ImagerTestDlg.h"


// CPosicodeDlg dialog

IMPLEMENT_DYNAMIC(CPosicodeDlg, CDialog)

CPosicodeDlg::CPosicodeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPosicodeDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bPosi_Lim1(FALSE)
	, m_bPosi_Lim2(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{
	
}

CPosicodeDlg::~CPosicodeDlg()
{
	
}

void CPosicodeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_POSILIM1, m_bPosi_Lim1);
	DDX_Check(pDX, IDC_CHECK_POSILIM2, m_bPosi_Lim2);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
}


BEGIN_MESSAGE_MAP(CPosicodeDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CPosicodeDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CPosicodeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
	
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PPOSICODE_PARAMS pPosicode = new POSICODE_PARAMS();

	if(IMAGER_GetPOSICODE(pPosicode) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetPOSICODE()", NULL, MB_TOPMOST);

	m_bEnable		= pPosicode->bEnable;
	m_bPosi_Lim1	= pPosicode->bPosi_Lim1;
	m_bPosi_Lim2	= pPosicode->bPosi_Lim2;
	m_nMinLen		= pPosicode->nMinLen;
	m_nMaxLen		= pPosicode->nMaxLen;

	delete pPosicode;

	UpdateData(FALSE);

	return TRUE;  
}

void CPosicodeDlg::OnBnClickedOk()
{
	PPOSICODE_PARAMS pPosicode = new POSICODE_PARAMS();

	UpdateData(TRUE);

	pPosicode->bEnable			= m_bEnable;
	pPosicode->bPosi_Lim1		= m_bPosi_Lim1;
	pPosicode->bPosi_Lim2		= m_bPosi_Lim2;
	pPosicode->nMinLen			= m_nMinLen;
	pPosicode->nMaxLen			= m_nMaxLen;

	if(IMAGER_SetPOSICODE(pPosicode) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetPLANET()", NULL, MB_TOPMOST);

	delete pPosicode;

	OnOK();
}
