// PlanetDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "PlanetDlg.h"
#include "ImagerTestDlg.h"


// CPlanetDlg dialog

IMPLEMENT_DYNAMIC(CPlanetDlg, CDialog)

CPlanetDlg::CPlanetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPlanetDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXCD(FALSE)
{
	
}

CPlanetDlg::~CPlanetDlg()
{
	
}

void CPlanetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
}


BEGIN_MESSAGE_MAP(CPlanetDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CPlanetDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CPlanetDlg message handlers

BOOL CPlanetDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
		
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PPLANET_PARAMS pPlanet = new PLANET_PARAMS();

	if(IMAGER_GetPLANET(pPlanet) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetPLANET()", NULL, MB_TOPMOST);

	m_bEnable	= pPlanet->bEnable;
	m_bXCD		= pPlanet->bXCD;

	delete pPlanet;

	UpdateData(FALSE);

	return TRUE;  
}


void CPlanetDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PPLANET_PARAMS pPlanet = new PLANET_PARAMS();

	pPlanet->bEnable		= m_bEnable;
	pPlanet->bXCD			= m_bXCD;

	if(IMAGER_SetPLANET(pPlanet) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetPLANET()", NULL, MB_TOPMOST);

	delete pPlanet;	

	OnOK();
}
