// OcrDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "OcrDlg.h"
#include "ImagerTestDlg.h"

// COcrDlg dialog

IMPLEMENT_DYNAMIC(COcrDlg, CDialog)

COcrDlg::COcrDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COcrDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_strEditTemplate(_T(""))
	, m_strEditGroupG(_T(""))
	, m_strEditGroupH(_T(""))
	, m_strCheckChar(_T(""))
{

}

COcrDlg::~COcrDlg()
{
}

void COcrDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Control(pDX, IDC_COMBO_MODE, m_ctrlComboMode);
	DDX_Text(pDX, IDC_EDIT_TEMPLATE, m_strEditTemplate);
	DDX_Text(pDX, IDC_EDIT_GROUPG, m_strEditGroupG);
	DDX_Text(pDX, IDC_EDIT_GROUPH, m_strEditGroupH);
	DDX_Text(pDX, IDC_EDIT_CHECKCHAR, m_strCheckChar);
}


BEGIN_MESSAGE_MAP(COcrDlg, CDialog)
	ON_BN_CLICKED(IDOK, &COcrDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL COcrDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	POCR_PARAMS pOcr = new OCR_PARAMS();

	if(IMAGER_GetOCR(pOcr) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetOcr()", NULL, MB_TOPMOST);

	m_bEnable = pOcr->bEnable;

	m_ctrlComboMode.InsertString(0, L"OCR_DISABLED");
	m_ctrlComboMode.InsertString(1, L"OCR_A");
	m_ctrlComboMode.InsertString(2, L"OCR_B");
	m_ctrlComboMode.InsertString(3, L"OCR_MONEY");
	m_ctrlComboMode.InsertString(4, L"OCR_MICR_UNSUPPORTED");
	m_ctrlComboMode.SetCurSel(pOcr->nMode);

	m_strEditTemplate	= (CString)pOcr->szTemplate;
	m_strEditGroupG		= (CString)pOcr->szGroupG;
	m_strEditGroupH		= (CString)pOcr->szGroupH;
	m_strCheckChar		= (CString)pOcr->szCheckChar;

	delete pOcr;

	UpdateData(FALSE);

	return TRUE;  
}

void COcrDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	POCR_PARAMS pOcr = new OCR_PARAMS();

	pOcr->bEnable	= m_bEnable;
	pOcr->nMode		= (OCR_MODE)m_ctrlComboMode.GetCurSel();
	wsprintf(pOcr->szTemplate, L"%s", m_strEditTemplate);
	wsprintf(pOcr->szGroupG, L"%s", m_strEditGroupG);
	wsprintf(pOcr->szGroupH, L"%s", m_strEditGroupH);
	wsprintf(pOcr->szCheckChar, L"%s", m_strCheckChar);

	if(IMAGER_SetOCR(pOcr) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_SetOcr()", NULL, MB_TOPMOST);

	delete pOcr;

	OnOK();
}
