// MSIDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "MSIDlg.h"
#include "ImagerTestDlg.h"


// CMsiDlg dialog

IMPLEMENT_DYNAMIC(CMsiDlg, CDialog)

CMsiDlg::CMsiDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMsiDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXCD(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{
	
}

CMsiDlg::~CMsiDlg()
{
	
}

void CMsiDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
}


BEGIN_MESSAGE_MAP(CMsiDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CMsiDlg::OnBnClickedOk)
END_MESSAGE_MAP()

BOOL CMsiDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
		
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PMSI_PARAMS pMsi = new MSI_PARAMS();

	if(IMAGER_GetMSI(pMsi) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetMSI()", NULL, MB_TOPMOST);

	m_bEnable	= pMsi->bEnable;
	m_bXCD		= pMsi->bXCD;
	m_nMinLen	= pMsi->nMinLen;
	m_nMaxLen	= pMsi->nMaxLen;

	delete pMsi;

	UpdateData(FALSE);

	return TRUE; 
}


void CMsiDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PMSI_PARAMS pMsi = new MSI_PARAMS();

	pMsi->bEnable	= m_bEnable;
	pMsi->bXCD		= m_bXCD;
	pMsi->nMinLen	= m_nMinLen;
	pMsi->nMaxLen	= m_nMaxLen;

	if(IMAGER_SetMSI(pMsi) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetMSI()", NULL, MB_TOPMOST);

	delete pMsi;

	OnOK();
}
