// IqTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "IqTestDlg.h"
#include "ImagerTestDlg.h"
#include "IqOptionDlg.h"


// CIqTestDlg dialog

IMPLEMENT_DYNAMIC(CIqTestDlg, CDialog)

CIqTestDlg::CIqTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CIqTestDlg::IDD, pParent)
	, m_strEditIqData(_T(""))
{

}

CIqTestDlg::~CIqTestDlg()
{
}

void CIqTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATIC_IQ, m_ctrlStaticIqImage);
	DDX_Text(pDX, IDC_EDIT_IQDATA, m_strEditIqData);
}


BEGIN_MESSAGE_MAP(CIqTestDlg, CDialog)
	ON_MESSAGE(WM_IQ_DATA, OnIQImaging)
	ON_BN_CLICKED(IDC_BTN_IQSTART, &CIqTestDlg::OnBnClickedBtnIqstart)
	ON_BN_CLICKED(IDC_BTN_IQSTOP, &CIqTestDlg::OnBnClickedBtnIqstop)
	ON_BN_CLICKED(IDC_BTN_IQOPTION, &CIqTestDlg::OnBnClickedBtnIqoption)
	ON_WM_DESTROY()
END_MESSAGE_MAP()


BOOL CIqTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	IMAGER_IQInit(m_ctrlStaticIqImage);

	return TRUE;  
}

void CIqTestDlg::OnDestroy()
{
	CDialog::OnDestroy();

	IMAGER_IQImagingStop();

	IMAGER_IQUnInit();
}

LRESULT CIqTestDlg::OnIQImaging(WPARAM wParam, LPARAM lParam)
{
	TCHAR	szBarData[1024] = {0, };

	IMAGER_IQGetBarcodeData(szBarData);

	m_strEditIqData = szBarData;

	UpdateData(FALSE);
	return LRESULT();
}

void CIqTestDlg::OnBnClickedBtnIqstart()
{
	IMAGER_IQImagingStart();	
}

void CIqTestDlg::OnBnClickedBtnIqstop()
{
	IMAGER_IQImagingStop();
}

void CIqTestDlg::OnBnClickedBtnIqoption()
{
	IMAGER_IQImagingStop();

	CIqOptionDlg IqOptionDlg;

	IqOptionDlg.DoModal();
}




