// IqOptionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "IqOptionDlg.h"
#include "ImagerTestDlg.h"


// CIqOptionDlg dialog

IMPLEMENT_DYNAMIC(CIqOptionDlg, CDialog)

CIqOptionDlg::CIqOptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CIqOptionDlg::IDD, pParent)
	, m_nIQType(0)
	, m_strIqSaveFolder(_T(""))
	, m_strIqFileName(_T(""))
	, m_strSaveFormat(_T(""))
{

}

CIqOptionDlg::~CIqOptionDlg()
{
}

void CIqOptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Radio(pDX, IDC_RADIO_AZTEC, m_nIQType);
	DDX_Text(pDX, IDC_EDIT_FOLDER, m_strIqSaveFolder);
	DDX_Text(pDX, IDC_EDIT_NAME, m_strIqFileName);
	DDX_Text(pDX, IDC_EDIT_FORMAT, m_strSaveFormat);
	DDX_Control(pDX, IDC_EDIT_NAME, m_ctrlEditIqFileName);
	DDX_Control(pDX, IDC_COMBO_SAVEMODE, m_ctrlComboSaveMode);
}


BEGIN_MESSAGE_MAP(CIqOptionDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CIqOptionDlg::OnBnClickedOk)
	ON_CBN_SELCHANGE(IDC_COMBO_SAVEMODE, &CIqOptionDlg::OnCbnSelchangeComboSavemode)
END_MESSAGE_MAP()


BOOL CIqOptionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	m_ctrlComboSaveMode.InsertString(0, L"DATE MODE");
	m_ctrlComboSaveMode.InsertString(1, L"CUSTOM WITH NUM MODE");
	m_ctrlComboSaveMode.InsertString(2, L"CUSTOM MODE");

	GetOption();

	return TRUE; 
}

void CIqOptionDlg::OnBnClickedOk()
{
	if(SetOption() == TRUE)
		OnOK();
}

BOOL CIqOptionDlg::GetOption(void)
{
	PIQ_PARAMS pIQOption = new IQ_PARAMS();

	if(IMAGER_IQGetOption(pIQOption) == FALSE)
	{
		::MessageBox(NULL, L"Error : IMAGER_IQGetOption()", NULL, MB_TOPMOST);
		return FALSE;
	}

	m_nIQType			= pIQOption->nIQType;
	m_strIqSaveFolder	= pIQOption->szSaveFolder;
	m_strIqFileName		= pIQOption->szFileName;
	m_strSaveFormat		= L".BMP";
	m_ctrlComboSaveMode.SetCurSel(pIQOption->nSaveMode);	

	if(pIQOption->nSaveMode == 0)
		m_ctrlEditIqFileName.EnableWindow(FALSE);
	else
		m_ctrlEditIqFileName.EnableWindow(TRUE);

	delete pIQOption;

	UpdateData(FALSE);

	return TRUE;
}

BOOL CIqOptionDlg::SetOption(void)
{
	UpdateData(TRUE);

	PIQ_PARAMS pIQOption = new IQ_PARAMS();

	pIQOption->nSaveMode	= m_ctrlComboSaveMode.GetCurSel();
	pIQOption->nIQType		= m_nIQType;
	wsprintf(pIQOption->szSaveFolder, L"%s", m_strIqSaveFolder);
	wsprintf(pIQOption->szFileName, L"%s", m_strIqFileName);

	if(IMAGER_IQSetOption(pIQOption) == FALSE)
	{
		::MessageBox(NULL, L"Error : IMAGER_IQSetOption()", NULL, MB_TOPMOST);
		return FALSE;
	}

	delete pIQOption;

	return TRUE;
}

void CIqOptionDlg::OnCbnSelchangeComboSavemode()
{
	UpdateData(TRUE);

	if(m_ctrlComboSaveMode.GetCurSel() == 0)
		m_ctrlEditIqFileName.EnableWindow(FALSE);
	else
		m_ctrlEditIqFileName.EnableWindow(TRUE);
}
