// Int25Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "Int25Dlg.h"
#include "ImagerTestDlg.h"


// CInt25Dlg dialog

IMPLEMENT_DYNAMIC(CInt25Dlg, CDialog)

CInt25Dlg::CInt25Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CInt25Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bCDV(FALSE)
	, m_bXCD(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{
	
}

CInt25Dlg::~CInt25Dlg()
{
	
}

void CInt25Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_CDV, m_bCDV);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
}


BEGIN_MESSAGE_MAP(CInt25Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CInt25Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CInt25Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
	
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PINT25_PARAMS pInt25 = new INT25_PARAMS();

	if(IMAGER_GetINT25(pInt25) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetINT25()", NULL, MB_TOPMOST);

	m_bEnable	= pInt25->bEnable;
	m_bCDV		= pInt25->bCDV;
	m_bXCD		= pInt25->bXCD;
	m_nMinLen	= pInt25->nMinLen;
	m_nMaxLen	= pInt25->nMaxLen;

	delete pInt25;

	UpdateData(FALSE);

	return TRUE;  
}

void CInt25Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PINT25_PARAMS pInt25 = new INT25_PARAMS();

	pInt25->bEnable		= m_bEnable;
	pInt25->bCDV		= m_bCDV;
	pInt25->bXCD		= m_bXCD;
	pInt25->nMinLen		= m_nMinLen;
	pInt25->nMaxLen		= m_nMaxLen;

	if(IMAGER_SetINT25(pInt25) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetINT25()", NULL, MB_TOPMOST);
	
	delete pInt25;

	OnOK();
}


