/********************************************************************
created		:	2011/10/18
file base	: 	ImagerTest.exe

file ext	:	cpp
author		:	Dong-Hyun Eum & Eun-Taek Lee

purpose		:	Imager C++ Demo Program
Report		:	2012. 01. 13 [01/13/2012 vision7901] v1.0.0 - Release Version
				2012. 04. 13 [04/13/2012 vision7901] v1.1.0 - VGA Device 
*********************************************************************/

#include "stdafx.h"
#include "ImagerTest.h"
#include "ImagerTestDlg.h"
#include "SymbologyDlg.h"
#include "AboutDlg.h"
#include "TestDlg.h"
#include "ScanOptionDlg.h"
#include "CamTestDlg.h"
#include "IqTestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CImagerTestDlg dialog

CImagerTestDlg::CImagerTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CImagerTestDlg::IDD, pParent)
	, m_strStaticType(_T(""))
	, m_strEditData(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_fontType = NULL;
	m_fontData = NULL;
}

void CImagerTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_STATIC_TYPE, m_strStaticType);
	DDX_Text(pDX, IDC_EDIT_DATA, m_strEditData);
}

BEGIN_MESSAGE_MAP(CImagerTestDlg, CDialog)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_SCAN_DATA, OnScanRead)
	ON_MESSAGE(WM_HOTKEY, OnHotKey)	
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_SYMBOLOGY, &CImagerTestDlg::OnBnClickedBtnSymbology)
	ON_BN_CLICKED(IDC_BTN_SCAN, &CImagerTestDlg::OnBnClickedBtnScan)
	ON_BN_CLICKED(IDC_BTN_SCANCANCEL, &CImagerTestDlg::OnBnClickedBtnScancancel)
	ON_BN_CLICKED(IDC_BTN_SCANOPTION, &CImagerTestDlg::OnBnClickedBtnScanoption)
	ON_BN_CLICKED(IDC_BTN_INFO, &CImagerTestDlg::OnBnClickedBtnInfo)
	ON_BN_CLICKED(IDC_BTN_NEW, &CImagerTestDlg::OnBnClickedBtnNew)
	ON_BN_CLICKED(IDC_BTN_CLOSE, &CImagerTestDlg::OnBnClickedBtnClose)
	ON_BN_CLICKED(IDC_BTN_CAMTEST, &CImagerTestDlg::OnBnClickedBtnCamtest)
	ON_BN_CLICKED(IDC_BTN_IQIMAGE, &CImagerTestDlg::OnBnClickedBtnIqimage)
END_MESSAGE_MAP()


BOOL CImagerTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_bKeyFlag			= FALSE;	
	m_bSyncMode			= FALSE;
	m_bContinueMode		= FALSE;
	m_bContinueFlag		= FALSE;
	m_bNewForm			= FALSE;
	m_bCamDlgOpen		= FALSE;
	m_bIqDlgOpen		= FALSE;

	SetCtrlFont();


	m_strStaticType = L"TYPE";
	m_strEditData	= L"DATA";

	if(IMAGER_Open() == FALSE)
		::MessageBox(NULL, L"ERROR : IMAGER_Open()", NULL, MB_TOPMOST);

	IMAGER_SetSymbologyAll();

	m_DeviceType = IMAGER_GetDeviceType();

	if((m_DeviceType == DEVICE_M3SMART_CE) || (m_DeviceType == DEVICE_M3GREEN) || (m_DeviceType == DEVICE_M3T) || (m_DeviceType == DEVICE_M3POS) || (m_DeviceType == DEVICE_M3UL10_CE) || (m_DeviceType == DEVICE_M3ORANGEPLUS_CE)  ||(m_DeviceType == DEVICE_M3TPLUS_CE)  || (m_DeviceType == DEVICE_M3BLACK_CE))
	{
		// Only for WinCE
		MoveWindow(0, 0, 240, 320);

		m_bWinCE = TRUE;

		RegisterHotKey(this->m_hWnd, HOTKEY_ONE, MOD_KEYUP, VK_F22);
		RegisterHotKey(this->m_hWnd, HOTKEY_TWO, MOD_KEYUP, 0);
		RegisterHotKey(this->m_hWnd, HOTKEY_THREE, MOD_KEYUP, 0);

	}
	else
	{
		m_bWinCE = FALSE;

		RegisterHotKey(this->m_hWnd, HOTKEY_ONE, MOD_KEYUP, VK_F14);
		RegisterHotKey(this->m_hWnd, HOTKEY_TWO, MOD_KEYUP, 0);
		RegisterHotKey(this->m_hWnd, HOTKEY_THREE, MOD_KEYUP, 0);
	}

	if ( m_DeviceType == DEVICE_M3BLACK )
	{
		GetDlgItem(IDC_BTN_IQIMAGE)->EnableWindow(FALSE);
	}

	UpdateData(FALSE);
	
	return TRUE;  
}

void CImagerTestDlg::OnDestroy()
{
	CDialog::OnDestroy();

	UnregisterHotKey(this->m_hWnd, HOTKEY_ONE);
	UnregisterHotKey(this->m_hWnd, HOTKEY_TWO);
	UnregisterHotKey(this->m_hWnd, HOTKEY_THREE);

	ReleaseCtrlFont();

	if(IMAGER_Close() == FALSE)
		::MessageBox(NULL, L"ERROR : IMAGER_Close()", NULL, MB_TOPMOST);

}

LRESULT CImagerTestDlg::OnHotKey(WPARAM wParam, LPARAM lParam)
{
	if(m_bCamDlgOpen == TRUE)
	{
		if(LOWORD(lParam) == 0x0000 &&(wParam == HOTKEY_ONE ||wParam == HOTKEY_TWO ||wParam == HOTKEY_THREE))
		{
			IMAGER_CAMCapture();
		}		

		
	}
	else if(m_bIqDlgOpen == TRUE)
	{
		if(LOWORD(lParam) == 0x0000 &&(wParam == HOTKEY_ONE ||wParam == HOTKEY_TWO ||wParam == HOTKEY_THREE))
		{
			if(m_bKeyFlag == FALSE)
			{
				m_bKeyFlag = TRUE;

				IMAGER_IQImagingStart();
			}
			
		}	
		else if(LOWORD(lParam) == 0x1000 &&(wParam == HOTKEY_ONE ||wParam == HOTKEY_TWO ||wParam == HOTKEY_THREE))
		{
			if(m_bKeyFlag == TRUE)
			{
				m_bKeyFlag = FALSE; 

				if(m_bSyncMode == FALSE)
					IMAGER_IQImagingStop();
			}			
		}
	}
	else
	{
		if(LOWORD(lParam) == 0x0000 &&(wParam == HOTKEY_ONE ||wParam == HOTKEY_TWO ||wParam == HOTKEY_THREE))
		{
			if(m_bKeyFlag == FALSE)
			{
				m_bKeyFlag = TRUE;

				if(m_bContinueMode == TRUE)
				{
					if(m_bContinueFlag == FALSE)
					{					
						IMAGER_Read();
						m_bContinueFlag = TRUE;
					}
					else
					{					
						IMAGER_ReadCancel();	
						m_bContinueFlag = FALSE;
					}
				}
				else
				{	
					IMAGER_Read();	
				}		
			}	
		}
		else if(LOWORD(lParam) == 0x1000 &&(wParam == HOTKEY_ONE ||wParam == HOTKEY_TWO ||wParam == HOTKEY_THREE))
		{
			if(m_bKeyFlag == TRUE)
			{
				m_bKeyFlag = FALSE; 			

				if(m_bSyncMode == FALSE)
				{		
					IMAGER_ReadCancel();					

					if(m_bContinueMode == TRUE)
						m_bContinueFlag = FALSE;
				}						
			}
		}
	}

	return LRESULT();
}

LRESULT CImagerTestDlg::OnScanRead(WPARAM wParam, LPARAM lParam)
{
	if(m_bNewForm == TRUE)
		return FALSE;

	TCHAR	szBarType[1024] = {0, };
	TCHAR	szBarData[1024] = {0, };

	IMAGER_GetScanData(szBarType, szBarData);

	m_strStaticType = szBarType;
	m_strEditData	= szBarData;

	UpdateData(FALSE);

	return LRESULT();
}

void CImagerTestDlg::OnBnClickedBtnScan()
{
	IMAGER_Read();
}

void CImagerTestDlg::OnBnClickedBtnScancancel()
{
	IMAGER_ReadCancel();
}

void CImagerTestDlg::OnBnClickedBtnSymbology()
{
	IMAGER_ReadCancel();	

	CSymbologyDlg SymbologyDlg;

	SymbologyDlg.DoModal();	
}

void CImagerTestDlg::OnBnClickedBtnScanoption()
{
	IMAGER_ReadCancel();	

	CScanOptionDlg ScanOptionDlg;

	ScanOptionDlg.DoModal();
}

void CImagerTestDlg::OnBnClickedBtnInfo()
{
	IMAGER_ReadCancel();	

	CAboutDlg AboutDlg;

	AboutDlg.DoModal();
}

void CImagerTestDlg::OnBnClickedBtnCamtest()
{
	IMAGER_ReadCancel();	

	m_bCamDlgOpen = TRUE;

	CCamTestDlg CamTestDlg;

	CamTestDlg.DoModal();

	m_bCamDlgOpen = FALSE;
}

void CImagerTestDlg::OnBnClickedBtnIqimage()
{
	IMAGER_ReadCancel();	

	m_bIqDlgOpen = TRUE;

	CIqTestDlg IqTestDlg;

	IqTestDlg.DoModal();

	m_bIqDlgOpen = FALSE;
}

void CImagerTestDlg::OnBnClickedBtnNew()
{
	IMAGER_ReadCancel();	

	m_bNewForm = TRUE;

	CTestDlg TestDlg;

	if(TestDlg.DoModal() == IDOK)
		m_bNewForm = FALSE;
}

void CImagerTestDlg::OnBnClickedBtnClose()
{
	IMAGER_ReadCancel();	

	CImagerTestDlg::OnCancel();
}

void CImagerTestDlg::ReleaseCtrlFont()
{
	if ( m_fontType != NULL )
	{
		m_fontType->DeleteObject();
		delete m_fontType;
		m_fontType = NULL;
	}

	if ( m_fontData != NULL )
	{
		m_fontData->DeleteObject();
		delete m_fontData;
		m_fontData = NULL;
	}
}

void CImagerTestDlg::SetCtrlFont()
{
	ReleaseCtrlFont();

	m_fontType = new CFont();
	m_fontData = new CFont();

	CreateCtrlFont( this, GetDlgItem(IDC_STATIC_TYPE), m_fontType, 12, 900 );
	CreateCtrlFont( this, GetDlgItem(IDC_EDIT_DATA), m_fontData, 12, 900 );
}
