// Ean8Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "Ean8Dlg.h"
#include "ImagerTestDlg.h"


// CEan8Dlg dialog

IMPLEMENT_DYNAMIC(CEan8Dlg, CDialog)

CEan8Dlg::CEan8Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEan8Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXCD(FALSE)
	, m_bAddOn(FALSE)
{
	
}

CEan8Dlg::~CEan8Dlg()
{
	
}

void CEan8Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_ADDON, m_bAddOn);
}


BEGIN_MESSAGE_MAP(CEan8Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CEan8Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CEan8Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
	
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PEAN8_PARAMS pEan8 = new EAN8_PARAMS();

	if(IMAGER_GetEAN8(pEan8) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetEAN8()", NULL, MB_TOPMOST);

	m_bEnable	= pEan8->bEnable;
	m_bXCD		= pEan8->bXCD;
	m_bAddOn	= pEan8->bAddOn;

	delete pEan8;

	UpdateData(FALSE);

	return TRUE;  
}

void CEan8Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PEAN8_PARAMS pEan8 = new EAN8_PARAMS();

	pEan8->bEnable	= m_bEnable;
	pEan8->bXCD		= m_bXCD;
	pEan8->bAddOn	= m_bAddOn;

	if(IMAGER_SetEAN8(pEan8) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetEAN8()", NULL, MB_TOPMOST);

	delete pEan8;

	OnOK();
}
