// DecOptionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "DecOptionDlg.h"
#include "ImagerTestDlg.h"


// CDecOptionDlg dialog

IMPLEMENT_DYNAMIC(CDecOptionDlg, CDialog)

CDecOptionDlg::CDecOptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDecOptionDlg::IDD, pParent)
	, m_nLinearRange(0)
	, m_nPrintWeight(0)
	, m_nMaxDecode(0)
	, m_nMaxSearch(0)
	, m_bVideoReverse(FALSE)
{

}

CDecOptionDlg::~CDecOptionDlg()
{
}

void CDecOptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_DECODEMODE, m_ctrlComboDecodeMode);
	DDX_Text(pDX, IDC_EDIT_LINEARRANGE, m_nLinearRange);
	DDX_Text(pDX, IDC_EDIT_PRINTWEIGHT, m_nPrintWeight);
	DDX_Text(pDX, IDC_EDIT_MAXDECODE, m_nMaxDecode);
	DDX_Text(pDX, IDC_EDIT_MAXSEARCH, m_nMaxSearch);
	DDX_Check(pDX, IDC_CHECK_VIDEOREVERSE, m_bVideoReverse);
	DDX_Control(pDX, IDC_SPIN_LINEARRANGE, m_ctrlSpinLinearRange);
	DDX_Control(pDX, IDC_SPIN_PRINTWEIGHT, m_ctrlSpinPrintWeight);
	DDX_Control(pDX, IDC_SPIN_MAXDECODE, m_ctrlSpinMaxDecode);
	DDX_Control(pDX, IDC_SPIN_MAXSEARCH, m_ctrlSpinMaxSearch);
}


BEGIN_MESSAGE_MAP(CDecOptionDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CDecOptionDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CDecOptionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	m_ctrlComboDecodeMode.InsertString(0, L"STANDARD OMNI");
	m_ctrlComboDecodeMode.InsertString(1, L"QUICK OMNI(2D)");
	m_ctrlComboDecodeMode.InsertString(2, L"AGRESSIVE LINEAR(1D)");

	m_ctrlSpinLinearRange.SetRange32(1, 6);
	m_ctrlSpinPrintWeight.SetRange32(1, 7);
	m_ctrlSpinMaxDecode.SetRange32(1, 10000);
	m_ctrlSpinMaxSearch.SetRange32(1, 10000);

	GetOption();

	return TRUE;  
}

BOOL CDecOptionDlg::GetOption(void)
{
	PDECOPTION_PARAMS pDecOption = new DECOPTION_PARAMS();

	if(IMAGER_GetDecOption(pDecOption) == FALSE)
	{
		::MessageBox(NULL, L"ERROR : IMAGER_GetDecOption()", NULL, MB_TOPMOST);
		return FALSE;
	}

	m_ctrlComboDecodeMode.SetCurSel(pDecOption->nDecodeMode);
	m_nLinearRange	= pDecOption->nLinearRange;
	m_nPrintWeight	= pDecOption->nPrintWeight;
	m_nMaxDecode	= pDecOption->nMaxDecode;
	m_nMaxSearch	= pDecOption->nMaxSearch;
	m_bVideoReverse = pDecOption->bVideoReverse;

	UpdateData(FALSE);

	delete pDecOption;

	return TRUE;
}

BOOL CDecOptionDlg::SetOption(void)
{
	UpdateData(TRUE);

	PDECOPTION_PARAMS pDecOption = new DECOPTION_PARAMS();

	pDecOption->nDecodeMode		= m_ctrlComboDecodeMode.GetCurSel();
	pDecOption->nLinearRange	= m_nLinearRange;
	pDecOption->nPrintWeight	= m_nPrintWeight;
	pDecOption->nMaxDecode		= m_nMaxDecode;
	pDecOption->nMaxSearch		= m_nMaxSearch;
	pDecOption->bVideoReverse	= m_bVideoReverse;

	if((m_ctrlComboDecodeMode.GetCurSel() > 2) || (m_ctrlComboDecodeMode.GetCurSel() < 0))
	{
		::MessageBox(NULL, L"Error : Retry set DecodeMode", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}	

	if(IMAGER_SetDecOption(pDecOption) == FALSE)
	{
		::MessageBox(NULL, L"ERROR : IMAGER_SetDecOption()", NULL, MB_TOPMOST);
		return FALSE;
	}

	delete pDecOption;

	return TRUE;
}

void CDecOptionDlg::OnBnClickedOk()
{
	if(SetOption() == TRUE)
		OnOK();

}
