// CompositeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "CompositeDlg.h"
#include "ImagerTestDlg.h"


// CCompositeDlg dialog

IMPLEMENT_DYNAMIC(CCompositeDlg, CDialog)

CCompositeDlg::CCompositeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCompositeDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bComposite_Upc(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{
	
}

CCompositeDlg::~CCompositeDlg()
{
	
}

void CCompositeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_COMPOSITE, m_bComposite_Upc);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
}


BEGIN_MESSAGE_MAP(CCompositeDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCompositeDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CCompositeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
	
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PCOMPOSITE_PARAMS pComposite = new COMPOSITE_PARAMS();

	if(IMAGER_GetCOMPOSITE(pComposite) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetCOMPOSITE()", NULL, MB_TOPMOST);

	m_bEnable			= pComposite->bEnable;
	m_bComposite_Upc	= pComposite->bComposite_Upc;
	m_nMinLen			= pComposite->nMinLen;
	m_nMaxLen			= pComposite->nMaxLen;

	delete pComposite;

	UpdateData(FALSE);

	return TRUE; 
}

void CCompositeDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCOMPOSITE_PARAMS pComposite = new COMPOSITE_PARAMS();

	pComposite->bEnable				= m_bEnable;
	pComposite->bComposite_Upc		= m_bComposite_Upc;
	pComposite->nMinLen				= m_nMinLen;
	pComposite->nMaxLen				= m_nMaxLen;

	if(IMAGER_SetCOMPOSITE(pComposite) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetCOMPOSITE()", NULL, MB_TOPMOST);

	delete pComposite;

	OnOK();
}
