// Code39Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "Code39Dlg.h"
#include "ImagerTestDlg.h"

// CCode39Dlg dialog

IMPLEMENT_DYNAMIC(CCode39Dlg, CDialog)

CCode39Dlg::CCode39Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCode39Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bCDV(FALSE)
	, m_bXCD(FALSE)
	, m_bFullASCII(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
	, m_nFormat(0)
{
	
}

CCode39Dlg::~CCode39Dlg()
{
	
}

void CCode39Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_CDV, m_bCDV);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_FULLASCII, m_bFullASCII);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);	
	DDX_Radio(pDX, IDC_RADIO_STANDARD, m_nFormat);
}


BEGIN_MESSAGE_MAP(CCode39Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCode39Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CCode39Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
	
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PCODE39_PARAMS	pCode39 = new CODE39_PARAMS();

	if(IMAGER_GetCODE39(pCode39) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetCODE39()", NULL, MB_TOPMOST);

	m_bEnable		= pCode39->bEnable;
	m_nFormat		= pCode39->nFormat;
	m_bCDV			= pCode39->bCDV;
	m_bXCD			= pCode39->bXCD;
	m_bFullASCII	= pCode39->bFullASCII;
	m_nMinLen		= pCode39->nMinLen;
	m_nMaxLen		= pCode39->nMaxLen;

	delete pCode39;

	UpdateData(FALSE);

	return TRUE;  
}

void CCode39Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODE39_PARAMS	pCode39 = new CODE39_PARAMS();

	pCode39->bEnable	= m_bEnable;
	pCode39->nFormat	= m_nFormat;
	pCode39->bCDV		= m_bCDV;
	pCode39->bXCD		= m_bXCD;
	pCode39->bFullASCII	= m_bFullASCII;
	pCode39->nMinLen	= m_nMinLen;
	pCode39->nMaxLen	= m_nMaxLen;

	if(IMAGER_SetCODE39(pCode39) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetCODE39()", NULL, MB_TOPMOST);

	delete pCode39;

	OnOK();
}
