// Code11Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "Code11Dlg.h"
#include "ImagerTestDlg.h"

// CCode11Dlg dialog

IMPLEMENT_DYNAMIC(CCode11Dlg, CDialog)

CCode11Dlg::CCode11Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCode11Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bCDV(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{
	
}

CCode11Dlg::~CCode11Dlg()
{
	
}

void CCode11Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_CDV, m_bCDV);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
}


BEGIN_MESSAGE_MAP(CCode11Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCode11Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CCode11Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
	
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	MoveWindow(0, 0, 240, 320);		

	PCODE11_PARAMS	pCode11 = new CODE11_PARAMS();

	if(IMAGER_GetCODE11(pCode11) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetCODE11()", NULL, MB_TOPMOST);

	m_bEnable	= pCode11->bEnable;
	m_bCDV		= pCode11->bCDV;
	m_nMinLen	= pCode11->nMinLen;
	m_nMaxLen	= pCode11->nMaxLen;

	delete pCode11;

	UpdateData(FALSE);

	return TRUE; 
}



void CCode11Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODE11_PARAMS	pCode11 = new CODE11_PARAMS();

	pCode11->bEnable	= m_bEnable;
	pCode11->bCDV		= m_bCDV;
	pCode11->nMinLen	= m_nMinLen;
	pCode11->nMaxLen	= m_nMaxLen;

	if(IMAGER_SetCODE11(pCode11) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetCODE11()", NULL, MB_TOPMOST);

	delete pCode11;

	OnOK();
}

