// CodabarDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "CodabarDlg.h"
#include "ImagerTestDlg.h"


// CCodabarDlg dialog

IMPLEMENT_DYNAMIC(CCodabarDlg, CDialog)

CCodabarDlg::CCodabarDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCodabarDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bCDV(FALSE)
	, m_bXCD(FALSE)
	, m_bXSS(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{
	
}

CCodabarDlg::~CCodabarDlg()
{

}

void CCodabarDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_CDV, m_bCDV);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_XSS, m_bXSS);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
}


BEGIN_MESSAGE_MAP(CCodabarDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCodabarDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CCodabarDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();
	
	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PCODABAR_PARAMS	pCodabar = new CODABAR_PARAMS();

	if(IMAGER_GetCODABAR(pCodabar) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetCODABAR()", NULL, MB_TOPMOST);

	m_bEnable	= pCodabar->bEnable;
	m_bCDV		= pCodabar->bCDV;
	m_bXCD		= pCodabar->bXCD;
	m_bXSS		= pCodabar->bXSS;
	m_nMinLen	= pCodabar->nMinLen;
	m_nMaxLen	= pCodabar->nMaxLen;

	delete pCodabar;

	UpdateData(FALSE);

	return TRUE;  
}

void CCodabarDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODABAR_PARAMS	pCodabar = new CODABAR_PARAMS();

	pCodabar->bEnable	= m_bEnable;
	pCodabar->bCDV		= m_bCDV;
	pCodabar->bXCD		= m_bXCD;
	pCodabar->bXSS		= m_bXSS;
	pCodabar->nMinLen	= m_nMinLen;
	pCodabar->nMaxLen	= m_nMaxLen;

	if(IMAGER_SetCODABAR(pCodabar) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_SetCODABAR()", NULL, MB_TOPMOST);

	delete pCodabar;

	OnOK();
}
