// CenteringDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "CenteringDlg.h"
#include "ImagerTestDlg.h"


// CCenteringDlg dialog

IMPLEMENT_DYNAMIC(CCenteringDlg, CDialog)

CCenteringDlg::CCenteringDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCenteringDlg::IDD, pParent)
	, m_nEditTop(0)
	, m_nEditLeft(0)
	, m_nEditRight(0)
	, m_nEidtBottom(0)
{

}

CCenteringDlg::~CCenteringDlg()
{
}

void CCenteringDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_TOP, m_nEditTop);
	DDX_Text(pDX, IDC_EDIT_LEFT, m_nEditLeft);
	DDX_Text(pDX, IDC_EDIT_RIGHT, m_nEditRight);
	DDX_Text(pDX, IDC_EDIT_BOTTOM, m_nEidtBottom);
	DDX_Control(pDX, IDC_SPIN_TOP, m_ctrlSpinTop);
	DDX_Control(pDX, IDC_SPIN_LEFT, m_ctrlSpinLeft);
	DDX_Control(pDX, IDC_SPIN_RIGHT, m_ctrlSpinRight);
	DDX_Control(pDX, IDC_SPIN_BOTTOM, m_ctrlSpinBottom);
}


BEGIN_MESSAGE_MAP(CCenteringDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCenteringDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CCenteringDlg message handlers

BOOL CCenteringDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	GetOption();	

	return TRUE;  
}

void CCenteringDlg::OnBnClickedOk()
{
	if(SetOption() == TRUE)
		OnOK();
}

BOOL CCenteringDlg::GetOption(void)
{
	RECT rect;

	if(IMAGER_GetCenteringWindow(&rect) == FALSE)
	{
		::MessageBox(NULL, L"ERROR : IMAGER_GetCenteringWindow()", NULL, MB_TOPMOST);
		return FALSE;
	}

	m_nEditTop		= rect.top;
	m_nEidtBottom	= rect.bottom;
	m_nEditLeft		= rect.left;
	m_nEditRight	= rect.right;

	m_ctrlSpinLeft.SetRange32(0, 375);
	m_ctrlSpinRight.SetRange32(376, 751);
	m_ctrlSpinTop.SetRange32(0, 239);
	m_ctrlSpinBottom.SetRange32(240, 479);

	UpdateData(FALSE);

	return TRUE;
}

BOOL CCenteringDlg::SetOption(void)
{
	UpdateData(TRUE);

	if((m_nEditTop > 239) || (m_nEditTop < 0))
	{
		::MessageBox(NULL, L"Error : Retry set Top", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}	

	if((m_nEidtBottom > 479) || (m_nEidtBottom < 240))
	{
		::MessageBox(NULL, L"Error : Retry set Bottom", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}	

	if((m_nEditLeft > 375) || (m_nEditLeft < 0))
	{
		::MessageBox(NULL, L"Error : Retry set Left", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}	

	if((m_nEditRight > 751) || (m_nEditRight < 376))
	{
		::MessageBox(NULL, L"Error : Retry set Right", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}	

	RECT rect;

	rect.top	= m_nEditTop;
	rect.bottom	= m_nEidtBottom;
	rect.left	= m_nEditLeft;
	rect.right	= m_nEditRight;

	if(IMAGER_SetCenteringWindow(&rect) == FALSE)
	{
		::MessageBox(NULL, L"ERROR : IMAGER_SetCenteringWindow()", NULL, MB_TOPMOST);
		return FALSE;
	}

	return TRUE;
}
