// CamTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "CamTestDlg.h"
#include "ImagerTestDlg.h"
#include "CamOptionDlg.h"
#include "ViewerDlg.h"

// CCamTestDlg dialog

IMPLEMENT_DYNAMIC(CCamTestDlg, CDialog)

CCamTestDlg::CCamTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCamTestDlg::IDD, pParent)
{

}

CCamTestDlg::~CCamTestDlg()
{
}

void CCamTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATIC_IMAGE, m_ctrlStaticImage);
	DDX_Control(pDX, IDC_BTN_START, m_ctrlBtnStart);
	DDX_Control(pDX, IDC_BTN_STOP, m_ctrlBtnStop);
	DDX_Control(pDX, IDC_BTN_CAPTURE, m_ctrlBtnCapture);
	DDX_Control(pDX, IDC_BTN_OPTION, m_ctrlBtnOption);
	DDX_Control(pDX, IDC_BTN_VIEWER, m_ctrlBtnViewer);
	DDX_Control(pDX, IDCANCEL, m_ctrlBtnClose);
}


BEGIN_MESSAGE_MAP(CCamTestDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_START, &CCamTestDlg::OnBnClickedBtnStart)
	ON_BN_CLICKED(IDC_BTN_STOP, &CCamTestDlg::OnBnClickedBtnStop)
	ON_BN_CLICKED(IDC_BTN_CAPTURE, &CCamTestDlg::OnBnClickedBtnCapture)
	ON_BN_CLICKED(IDC_BTN_OPTION, &CCamTestDlg::OnBnClickedBtnOption)
	ON_BN_CLICKED(IDC_BTN_VIEWER, &CCamTestDlg::OnBnClickedBtnViewer)
	ON_WM_DESTROY()
END_MESSAGE_MAP()


BOOL CCamTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	m_bPreview		= FALSE;

	IMAGER_CAMInit(m_ctrlStaticImage);

	return TRUE;
}

void CCamTestDlg::OnBnClickedBtnStart()
{
	m_ctrlBtnStart.EnableWindow(FALSE);
	m_ctrlBtnStop.EnableWindow(TRUE);
	m_ctrlBtnCapture.EnableWindow(TRUE);
	m_ctrlBtnOption.EnableWindow(FALSE);
	m_ctrlBtnViewer.EnableWindow(FALSE);
	m_ctrlBtnClose.EnableWindow(FALSE);

	IMAGER_CAMPreviewStart();
	m_bPreview = TRUE;
}

void CCamTestDlg::OnBnClickedBtnStop()
{
	m_ctrlBtnStart.EnableWindow(TRUE);
	m_ctrlBtnStop.EnableWindow(FALSE);
	m_ctrlBtnCapture.EnableWindow(FALSE);
	m_ctrlBtnOption.EnableWindow(TRUE);
	m_ctrlBtnViewer.EnableWindow(TRUE);
	m_ctrlBtnClose.EnableWindow(TRUE);

	IMAGER_CAMPreviewStop();
	m_bPreview = FALSE;
}

void CCamTestDlg::OnBnClickedBtnCapture()
{
	IMAGER_CAMCapture();
}

void CCamTestDlg::OnBnClickedBtnOption()
{
	CCamOptionDlg CamOptionDlg;

	CamOptionDlg.DoModal();
}

void CCamTestDlg::OnBnClickedBtnViewer()
{
	CViewerDlg ViewerDlg;

	ViewerDlg.DoModal();
}

void CCamTestDlg::OnDestroy()
{
	CDialog::OnDestroy();

	if(m_bPreview == TRUE)
		IMAGER_CAMPreviewStop();

	IMAGER_CAMUnInit();
}
