// CamOptionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImagerTest.h"
#include "CamOptionDlg.h"
#include "ImagerTestDlg.h"


// CCamOptionDlg dialog

IMPLEMENT_DYNAMIC(CCamOptionDlg, CDialog)

CCamOptionDlg::CCamOptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCamOptionDlg::IDD, pParent)
	, m_nSaveFormat(0)
	, m_nJpegQuality(0)
	, m_strSaveFolder(_T(""))
	, m_strFileName(_T(""))
	, m_strSaveFormat(_T(""))
{

}

CCamOptionDlg::~CCamOptionDlg()
{
}

void CCamOptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Radio(pDX, IDC_RADIO_JPG, m_nSaveFormat);
	DDX_Text(pDX, IDC_EDIT_JPEG, m_nJpegQuality);
	DDX_Control(pDX, IDC_COMBO_RESOLUTION, m_ctrlComboResolution);
	DDX_Text(pDX, IDC_EDIT_FOLDER, m_strSaveFolder);
	DDX_Text(pDX, IDC_EDIT_NAME, m_strFileName);
	DDX_Control(pDX, IDC_EDIT_NAME, m_ctrlEditFileName);
	DDX_Text(pDX, IDC_EDIT_FORMAT, m_strSaveFormat);
	DDX_Control(pDX, IDC_SPIN_JPEG, m_ctrlSpinJpegQuality);
	DDX_Control(pDX, IDC_COMBO_SAVEMODE, m_ctrlComboSaveMode);
}


BEGIN_MESSAGE_MAP(CCamOptionDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCamOptionDlg::OnBnClickedOk)
	ON_BN_CLICKED(IDC_RADIO_JPG, &CCamOptionDlg::OnBnClickedRadioJpg)
	ON_BN_CLICKED(IDC_RADIO_BMP, &CCamOptionDlg::OnBnClickedRadioBmp)
	ON_CBN_SELCHANGE(IDC_COMBO_SAVEMODE, &CCamOptionDlg::OnCbnSelchangeComboSavemode)
END_MESSAGE_MAP()


BOOL CCamOptionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CImagerTestDlg*	pImagerTestDlg = (CImagerTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pImagerTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	m_ctrlComboSaveMode.InsertString(0, L"DATE MODE");
	m_ctrlComboSaveMode.InsertString(1, L"CUSTOM WITH NUM MODE");
	m_ctrlComboSaveMode.InsertString(2, L"CUSTOM MODE");

	m_ctrlComboResolution.InsertString(0, L"640x480");
	m_ctrlComboResolution.InsertString(1, L"320x240");
	m_ctrlComboResolution.InsertString(2, L"160x120");

	m_ctrlSpinJpegQuality.SetRange32(0, 100);

	GetOption();

	return TRUE;  
}

void CCamOptionDlg::OnBnClickedOk()
{
	if(SetOption() == TRUE)
		OnOK();
}

BOOL CCamOptionDlg::GetOption(void)
{
	PCAM_PARAMS pCamOption = new CAM_PARAMS();

	if(IMAGER_CAMGetOption(pCamOption) == FALSE)
	{
		::MessageBox(NULL, L"Error : IMAGER_CAMGetOption()", NULL, MB_TOPMOST);
		return FALSE;
	}

	m_nSaveFormat		= pCamOption->nSaveFormat;
	m_nJpegQuality		= pCamOption->nJpegQuality;
	m_strSaveFolder		= pCamOption->szSaveFolder;
	m_strFileName		= pCamOption->szFileName;

	m_ctrlComboSaveMode.SetCurSel(pCamOption->nSaveMode);
	m_ctrlComboResolution.SetCurSel(pCamOption->nResolution);	

	if(m_nSaveFormat == 0)
		m_strSaveFormat = L".JPG";
	else
		m_strSaveFormat = L".BMP";

	if(pCamOption->nSaveMode == 0)
		m_ctrlEditFileName.EnableWindow(FALSE);
	else
		m_ctrlEditFileName.EnableWindow(TRUE);

	delete pCamOption;

	UpdateData(FALSE);

	return TRUE;
}

BOOL CCamOptionDlg::SetOption(void)
{
	UpdateData(TRUE);

	PCAM_PARAMS pCamOption = new CAM_PARAMS();

	pCamOption->nSaveFormat			= m_nSaveFormat;
	pCamOption->nJpegQuality		= m_nJpegQuality;

	if((m_ctrlComboResolution.GetCurSel() > 2) || (m_ctrlComboResolution.GetCurSel() < 0))
	{
		::MessageBox(NULL, L"Error : Retry set Resolution", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}

	if((m_ctrlComboSaveMode.GetCurSel() > 2) || (m_ctrlComboSaveMode.GetCurSel() < 0))
	{
		::MessageBox(NULL, L"Error : Retry set SaveMode", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}

	pCamOption->nSaveMode			= m_ctrlComboSaveMode.GetCurSel();
	pCamOption->nResolution			= m_ctrlComboResolution.GetCurSel();
	
	wsprintf(pCamOption->szSaveFolder, L"%s", m_strSaveFolder);
	wsprintf(pCamOption->szFileName, L"%s", m_strFileName);

	if(IMAGER_CAMSetOption(pCamOption) == FALSE)
	{
		::MessageBox(NULL, L"Error : IMAGER_CAMSetOption()", NULL, MB_TOPMOST);
		return FALSE;
	}

	delete pCamOption;
	
	return TRUE;
}

void CCamOptionDlg::OnBnClickedRadioJpg()
{
	m_nSaveFormat = 0;
 	m_strSaveFormat = L".JPG";
 	UpdateData(FALSE);
}

void CCamOptionDlg::OnBnClickedRadioBmp()
{
	m_nSaveFormat = 1;
 	m_strSaveFormat = L".BMP";
 	UpdateData(FALSE);
}

void CCamOptionDlg::OnCbnSelchangeComboSavemode()
{
	UpdateData(TRUE);

	if(m_ctrlComboSaveMode.GetCurSel() == 0)
		m_ctrlEditFileName.EnableWindow(FALSE);
	else
		m_ctrlEditFileName.EnableWindow(TRUE);
}
